//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package com.openbravo.pos.printer.screen;

import java.awt.*;
import com.openbravo.pos.printer.ticket.BasicTicket;

class JTicket extends javax.swing.JPanel {
    
    private static final int H_GAP = 8;
    private static final int V_GAP = 8;
    private static final int COLUMNS = 42;
    private static final int LINEWIDTH = COLUMNS * 7;    
    
    private BasicTicket basict;
   
    /** Creates new form JTicket */
    public JTicket(BasicTicket t) {
        
        basict = t;
        initComponents();
    }
    
    protected void paintComponent(Graphics g) {
        paintBorder(g);
        
        Graphics2D g2d = (Graphics2D) g;     
//        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
//        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        
        Insets i = getInsets();
        //g.setColor(getBackground());
        g2d.setPaint(new GradientPaint(getWidth() - i.left - i.right - 100, getHeight() - i.top - i.bottom - 100, getBackground()
                                     , getWidth() - i.left - i.right, getHeight() - i.top - i.bottom, new Color(0xf0f0f0), true));
        g2d.fillRect(i.left, i.top, getWidth() - i.left - i.right, getHeight() - i.top - i.bottom);
        
//        AffineTransform oldtrans = g2d.getTransform();
//        g2d.scale(0.75, 0.75);
        g.setColor(getForeground());
        basict.draw(g2d, i.left + H_GAP, i.top + V_GAP, LINEWIDTH);   
//        g2d.setTransform(oldtrans);
    }  
    
      
    public Dimension getPreferredSize() {
        Insets ins = getInsets();
        return new Dimension((int) (LINEWIDTH + 2 * H_GAP) + ins.left + ins.right
                           , (int) (basict.getHeight() + 2 * V_GAP) + ins.top + ins.bottom);
//        return new Dimension((int) (0.75 * (LINEWIDTH + 2 * H_GAP) + ins.left + ins.right)
//                           , (int) (0.75 * (basict.getHeight() + 2 * V_GAP) + ins.top + ins.bottom));
    }

    public Dimension getMaximumSize() {
        return getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return getPreferredSize();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setLayout(new java.awt.BorderLayout());

        setBackground(new java.awt.Color(255, 255, 255));
        setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
