//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package com.openbravo.pos.payment;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import com.openbravo.pos.forms.AppLocal;

/**
 *
 * @author adrianromero
 */
public class PaymentPanelType extends javax.swing.JPanel implements PaymentPanel {
    
    private double m_dTotal;
    private String m_sTransactionID;
    private JPaymentNotifier m_notifier;
    
    /** Creates new form JPaymentCash */
    public PaymentPanelType(JPaymentNotifier notifier) {
        
        m_notifier = notifier;
        
        initComponents();  
        
        m_jHolderName.addPropertyChangeListener("Edition", new RecalculateName());
        m_jCardNumber.addPropertyChangeListener("Edition", new RecalculateName());
        m_jExpirationDate.addPropertyChangeListener("Edition", new RecalculateName());
        
        
        m_jHolderName.addEditorKeys(m_jKeys);
        m_jCardNumber.addEditorKeys(m_jKeys);
        m_jExpirationDate.addEditorKeys(m_jKeys);

    }
    
    public JComponent getComponent(){
        return this;
    }
    
    public void activate(String sTransaction, double dTotal) {
        
        m_sTransactionID = sTransaction;
        m_dTotal = dTotal;
        
        resetState();
        
        m_jHolderName.activate();
    }
    
    private void resetState() {
        
        m_notifier.setStatus(false, false);  
              
        m_jHolderName.setText(null);
        m_jCardNumber.setText(null);
        m_jExpirationDate.setText(null);
    }
    
    public PaymentInfoMagcard getPaymentInfoMagcard() {

        if (m_dTotal > 0.0) {
            return new PaymentInfoMagcard(
                    m_jHolderName.getText(),
                    m_jCardNumber.getText(), 
                    m_jExpirationDate.getText(),
                    null,
                    null,                    
                    null,                    
                    m_sTransactionID,
                    m_dTotal);
        } else {
            return new PaymentInfoMagcardRefund(
                    m_jHolderName.getText(),
                    m_jCardNumber.getText(), 
                    m_jExpirationDate.getText(),
                    null,
                    null,                    
                    null,                    
                    m_sTransactionID,
                    m_dTotal);
        }
    }    
    
    private class RecalculateName implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            boolean isvalid = isValidHolder() && isValidCardNumber() && isValidExpirationDate();
            m_notifier.setStatus(isvalid, isvalid);
        }
    }  
    
    private boolean isValidHolder() {
        return !(m_jHolderName.getText() == null || m_jHolderName.getText().equals(""));
    }
    private boolean isValidCardNumber() {
        return !(m_jCardNumber.getText() == null || m_jCardNumber.getText().length() != 16);
    }
    private boolean isValidExpirationDate() {
        return !(m_jExpirationDate.getText() == null || m_jExpirationDate.getText().length() != 4);
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel2 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        m_jKeys = new com.openbravo.editor.JEditorKeys();
        jPanel4 = new javax.swing.JPanel();
        m_jCardNumber = new com.openbravo.editor.JEditorStringNumber();
        m_jExpirationDate = new com.openbravo.editor.JEditorStringNumber();
        m_jHolderName = new com.openbravo.editor.JEditorString();
        jLabel8 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new java.awt.BorderLayout());

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.Y_AXIS));
        jPanel1.add(m_jKeys);

        jPanel2.add(jPanel1, java.awt.BorderLayout.NORTH);

        add(jPanel2, java.awt.BorderLayout.EAST);

        jPanel4.setLayout(null);
        jPanel4.add(m_jCardNumber);
        m_jCardNumber.setBounds(110, 50, 180, 25);
        jPanel4.add(m_jExpirationDate);
        m_jExpirationDate.setBounds(110, 80, 110, 25);
        jPanel4.add(m_jHolderName);
        m_jHolderName.setBounds(110, 20, 180, 25);

        jLabel8.setText(AppLocal.getIntString("label.cardholder")); // NOI18N
        jPanel4.add(jLabel8);
        jLabel8.setBounds(20, 20, 90, 15);

        jLabel6.setText(AppLocal.getIntString("label.cardnumber")); // NOI18N
        jPanel4.add(jLabel6);
        jLabel6.setBounds(20, 50, 90, 15);

        jLabel7.setText(AppLocal.getIntString("label.cardexpdate")); // NOI18N
        jPanel4.add(jLabel7);
        jLabel7.setBounds(20, 80, 120, 15);

        add(jPanel4, java.awt.BorderLayout.CENTER);

        jLabel1.setText(AppLocal.getIntString("message.paymentgatewaytype")); // NOI18N
        jPanel5.add(jLabel1);

        add(jPanel5, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private com.openbravo.editor.JEditorStringNumber m_jCardNumber;
    private com.openbravo.editor.JEditorStringNumber m_jExpirationDate;
    private com.openbravo.editor.JEditorString m_jHolderName;
    private com.openbravo.editor.JEditorKeys m_jKeys;
    // End of variables declaration//GEN-END:variables
    
}
