//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package com.openbravo.pos.admin;

import java.awt.Component;
import java.util.UUID;
import com.openbravo.basic.BasicException;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.data.user.EditorRecord;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;

/**
 *
 * @author adrianromero
 */
public class RolesView extends javax.swing.JPanel implements EditorRecord {
    
    private Object m_oId;
    
    /** Creates new form RolesEditor */
    public RolesView(DirtyManager dirty) {
        initComponents();
        
        m_jName.getDocument().addDocumentListener(dirty);
        m_jText.getDocument().addDocumentListener(dirty);
        
        writeValueEOF();
    }
    
    public void writeValueEOF() {
        m_oId = null;
        m_jName.setText(null);
        m_jText.setText(null);
        m_jName.setEnabled(false);
        m_jText.setEnabled(false);
    }
    
    public void writeValueInsert() {
        m_oId = null;
        m_jName.setText(null);
        m_jText.setText(null);
        m_jName.setEnabled(true);
        m_jText.setEnabled(true);
    }
    
    public void writeValueDelete(Object value) {

        Object[] role = (Object[]) value;
        m_oId = role[0];
        m_jName.setText(Formats.STRING.formatValue(role[1]));
        m_jText.setText(Formats.BYTEA.formatValue(role[2]));
        m_jText.setCaretPosition(0);
        m_jName.setEnabled(false);
        m_jText.setEnabled(false);
    }   
    
    public void writeValueEdit(Object value) {

        Object[] role = (Object[]) value;
        m_oId = role[0];
        m_jName.setText(Formats.STRING.formatValue(role[1]));
        m_jText.setText(Formats.BYTEA.formatValue(role[2]));
        m_jText.setCaretPosition(0);
        m_jName.setEnabled(true);
        m_jText.setEnabled(true);
    }    
    
    public Object createValue() throws BasicException {

        Object[] role = new Object[3];
        role[0] = m_oId == null ? UUID.randomUUID().toString() : m_oId;
        role[1] = m_jName.getText();
        role[2] = Formats.BYTEA.parseValue(m_jText.getText());
        return role;
    }
    
    public Component getComponent() {
        return this;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        m_jName = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        m_jText = new javax.swing.JTextArea();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setPreferredSize(new java.awt.Dimension(150, 100));
        jPanel1.setLayout(null);

        jLabel2.setText(AppLocal.getIntString("Label.Name")); // NOI18N
        jPanel1.add(jLabel2);
        jLabel2.setBounds(20, 20, 80, 14);
        jPanel1.add(m_jName);
        m_jName.setBounds(100, 20, 260, 18);

        add(jPanel1, java.awt.BorderLayout.NORTH);

        jPanel2.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel2.setLayout(new java.awt.BorderLayout());

        m_jText.setFont(new java.awt.Font("DialogInput", 0, 12));
        jScrollPane1.setViewportView(m_jText);

        jPanel2.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(jPanel2, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField m_jName;
    private javax.swing.JTextArea m_jText;
    // End of variables declaration//GEN-END:variables
    
}
