//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007-2008 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.UserSells");
report.setReport("/com/openbravo/reports/usersales");
report.setResourceBundle("com/openbravo/reports/usersales_messages");

report.setSentence("SELECT PEOPLE.NAME, MIN(RECEIPTS.DATENEW) AS STARTDATE, MAX(RECEIPTS.DATENEW) AS ENDDATE, SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL " +
                "FROM PEOPLE, RECEIPTS, TICKETS, TICKETLINES WHERE PEOPLE.ID = TICKETS.PERSON AND RECEIPTS.ID = TICKETS.ID AND TICKETS.ID = TICKETLINES.TICKET AND ?(QBF_FILTER) " +
                "GROUP BY PEOPLE.NAME ORDER BY PEOPLE.NAME");
report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsDatesInterval());

report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("STARTDATE", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("ENDDATE", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);

return report;
