//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007-2008 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.ProductSales");
report.setReport("/com/openbravo/reports/productsales");
report.setResourceBundle("com/openbravo/reports/productsales_messages");

report.setSentence(
            "SELECT " +
            "PRODUCTS.REFERENCE, " +
            "PRODUCTS.NAME, " +
            "SUM(TICKETLINES.UNITS) AS UNITS, " +
            "SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL " +
            "FROM RECEIPTS, TICKETS, TICKETLINES, PRODUCTS " +
            "WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.ID = TICKETLINES.TICKET AND TICKETLINES.PRODUCT = PRODUCTS.ID AND ?(QBF_FILTER) " +
            "GROUP BY PRODUCTS.REFERENCE, PRODUCTS.NAME " +
            "ORDER BY PRODUCTS.NAME");
report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsDatesInterval());
report.addParameter("PRODUCTS.NAME");
report.addParameter("PRODUCTS.PRICEBUY");
report.addParameter("PRODUCTS.PRICESELL");
report.addParameter("PRODUCTS.CATEGORY");
report.addParameter("PRODUCTS.CODE");
report.addQBFFilter(new com.openbravo.pos.ticket.ProductFilter());

report.addField("REFERENCE", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("UNITS", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);

return report;

