//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007-2008 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.InventoryDiff");
report.setReport("/com/openbravo/reports/inventorydiff");
report.setResourceBundle("com/openbravo/reports/inventorydiff_messages");

report.setSentence("SELECT " +
                "LOCATIONS.ID AS LOCATIONID, LOCATIONS.NAME AS LOCATIONNAME, " +
                "PRODUCTS.REFERENCE, PRODUCTS.NAME, PRODUCTS.CATEGORY, CATEGORIES.NAME AS CATEGORYNAME, " +
                "SUM(CASE WHEN STOCKDIARY.UNITS <0 THEN STOCKDIARY.UNITS ELSE 0 END) AS UNITSOUT, " +
                "SUM(CASE WHEN STOCKDIARY.UNITS <0 THEN STOCKDIARY.UNITS * STOCKDIARY.PRICE ELSE 0 END) AS TOTALOUT, " +
                "SUM(CASE WHEN STOCKDIARY.UNITS >=0 THEN STOCKDIARY.UNITS ELSE 0 END) AS UNITSIN, SUM(CASE WHEN STOCKDIARY.UNITS >=0 THEN STOCKDIARY.UNITS * STOCKDIARY.PRICE ELSE 0 END) AS TOTALIN, " +
                "SUM(STOCKDIARY.UNITS) AS UNITSDIFF, " +
                "SUM(STOCKDIARY.UNITS * STOCKDIARY.PRICE) AS TOTALDIFF " +
                "FROM STOCKDIARY JOIN LOCATIONS ON STOCKDIARY.LOCATION = LOCATIONS.ID, " +
                "PRODUCTS LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID " +
                "WHERE PRODUCTS.ID = STOCKDIARY.PRODUCT " +
                "AND ?(QBF_FILTER) " +
                "GROUP BY LOCATIONS.ID, LOCATIONS.NAME, PRODUCTS.REFERENCE, PRODUCTS.NAME, PRODUCTS.CATEGORY, CATEGORIES.NAME " +
                "ORDER BY LOCATIONS.ID, CATEGORIES.NAME, PRODUCTS.NAME");
report.addParameter("STOCKDIARY.DATENEW");
report.addParameter("STOCKDIARY.DATENEW");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsDatesInterval());
report.addParameter("LOCATIONS.ID");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsLocationWithFirst());
report.addParameter("STOCKDIARY.REASON");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsReason());

report.addField("LOCATIONID", com.openbravo.data.loader.Datas.STRING);
report.addField("LOCATIONNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("REFERENCE", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORY", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORYNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("UNITSOUT", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTALOUT", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("UNITSIN", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTALIN", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("UNITSDIFF", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTALDIFF", com.openbravo.data.loader.Datas.DOUBLE);

return report;

