//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007-2008 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Inventory");
report.setReport("/com/openbravo/reports/inventory");
report.setResourceBundle("com/openbravo/reports/inventory_messages");

report.setSentence("SELECT " +
                "STOCKCURRENT.LOCATION AS LOCATIONID, " +
                "LOCATIONS.NAME AS LOCATIONNAME, " +
                "PRODUCTS.REFERENCE, " +
                "PRODUCTS.NAME AS NAME, " +
                "PRODUCTS.CATEGORY, " +
                "CATEGORIES.NAME AS CATEGORYNAME, " +
                "STOCKCURRENT.UNITS, " +
                "PRODUCTS.PRICEBUY, " +
                "PRODUCTS.PRICESELL, " +
                "COALESCE(PRODUCTS.STOCKVOLUME, 0) AS STOCKVOLUME, " +
                "COALESCE(PRODUCTS.STOCKCOST, 0) AS STOCKCOST, " +
                "COALESCE(STOCKCURRENT.STOCKSECURITY, 0) AS STOCKSECURITY, " +
                "COALESCE(STOCKCURRENT.STOCKMAXIMUM, 0) AS STOCKMAXIMUM " +
                "FROM STOCKCURRENT " +
                "JOIN LOCATIONS ON STOCKCURRENT.LOCATION = LOCATIONS.ID " +
                "JOIN PRODUCTS ON STOCKCURRENT.PRODUCT = PRODUCTS.ID " +
                "JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID " +
                "WHERE ?(QBF_FILTER) " +
                "ORDER BY STOCKCURRENT.LOCATION, CATEGORIES.NAME, PRODUCTS.NAME");
report.addParameter("PRODUCTS.NAME");
report.addParameter("PRODUCTS.PRICEBUY");
report.addParameter("PRODUCTS.PRICESELL");
report.addParameter("PRODUCTS.CATEGORY");
report.addParameter("PRODUCTS.CODE");
report.addQBFFilter(new com.openbravo.pos.ticket.ProductFilter());
report.addParameter("STOCKCURRENT.LOCATION");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsLocationWithFirst());

report.addField("LOCATIONID", com.openbravo.data.loader.Datas.STRING);
report.addField("LOCATIONNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("REFERENCE", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORY", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORYNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("UNITS", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("PRICEBUY", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("PRICESELL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("STOCKVOLUME", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("STOCKCOST", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("STOCKSECURITY", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("STOCKMAXIMUM", com.openbravo.data.loader.Datas.DOUBLE);

return report;
