//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007-2008 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.CustomersReport");
report.setReport("/com/openbravo/reports/customers");
report.setResourceBundle("com/openbravo/reports/customers_messages");

if (app.getSession().getDatabaseName().equals("HSQL Database Engine") ||
    app.getSession().getDatabaseName().equals("MySQL") ||
    app.getSession().getDatabaseName().equals("PostgreSQL")) {
    report.setSentence("SELECT ID, TAXID, NAME, ADDRESS, NOTES, CARD, MAXDEBT, CURDATE, CURDEBT " +
                     "FROM CUSTOMERS " +
                     "WHERE VISIBLE = TRUE AND ?(QBF_FILTER)");
} else if (app.getSession().getDatabaseName().equals("Oracle")) {
    report.setSentence("SELECT ID, TAXID, NAME, ADDRESS, NOTES, CARD, MAXDEBT, CURDATE, CURDEBT " +
                     "FROM CUSTOMERS " +
                     "WHERE VISIBLE = 1 AND ?(QBF_FILTER)");
}

report.addParameter("ID");
report.addParameter("NAME");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsCustomer());

report.addField("ID", com.openbravo.data.loader.Datas.STRING);
report.addField("TAXID", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("ADDRESS", com.openbravo.data.loader.Datas.STRING);
report.addField("NOTES", com.openbravo.data.loader.Datas.STRING);
report.addField("CARD", com.openbravo.data.loader.Datas.STRING);
report.addField("MAXDEBT", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("CURDATE", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("CURDEBT", com.openbravo.data.loader.Datas.DOUBLE);

return report;
