//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007-2008 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Closing");
report.setReport("/com/openbravo/reports/closedpos");
report.setResourceBundle("com/openbravo/reports/closedpos_messages");

report.setSentence("SELECT " + 
                    "CLOSEDCASH.HOST, " +
                    "CLOSEDCASH.HOSTSEQUENCE, " +
                    "CLOSEDCASH.MONEY, " +
                    "CLOSEDCASH.DATESTART, " +
                    "CLOSEDCASH.DATEEND, " +
                    "PAYMENTS.PAYMENT, " +
                    "SUM(PAYMENTS.TOTAL) AS TOTAL " +
                    "FROM CLOSEDCASH, PAYMENTS, RECEIPTS " +
                    "WHERE CLOSEDCASH.MONEY = RECEIPTS.MONEY AND PAYMENTS.RECEIPT = RECEIPTS.ID AND ?(QBF_FILTER) " +
                    "GROUP BY CLOSEDCASH.HOST, CLOSEDCASH.HOSTSEQUENCE, CLOSEDCASH.MONEY, CLOSEDCASH.DATESTART, CLOSEDCASH.DATEEND, PAYMENTS.PAYMENT " +
                    "ORDER BY CLOSEDCASH.HOST, CLOSEDCASH.HOSTSEQUENCE");
report.addParameter("CLOSEDCASH.DATEEND");
report.addParameter("CLOSEDCASH.DATEEND");
paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);

report.addField("HOST", com.openbravo.data.loader.Datas.STRING);
report.addField("SEQUENCE", com.openbravo.data.loader.Datas.INT);
report.addField("MONEY", com.openbravo.data.loader.Datas.STRING);
report.addField("DATESTART", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("DATEEND", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("PAYMENT", com.openbravo.data.loader.Datas.STRING);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);

return report;

