/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.tarjeta.virtual;

import com.izenpe.tarjeta.virtual.util.PropertiesReaderUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Scanner;

public class TarjetaVirtual {
    private static String ENTORNO;
    private static String VERSION;
    private static String IDIOMA;
    private static final String CMD_EXE = "cmd.exe";
    private static final String FILE_SEPARATOR;
    private static final String USER_HOME;
    private static final String DESKTOP_HOME;
    private static final String PROGRAMS_HOME;
    private static final String LOG_FILENAME = "vsc-izenpe.log";
    private static final String LOG_FILE_PATH;
    private static final String CIUDADANO_FILE_PATH;
    private static String CIUDADANO_MSI_FILENAME;
    private static final String PROFESIONAL_FILE_PATH;
    private static String PROFESIONAL_MSI_FILENAME;
    private static final String CIUDADANO_APPLICATION_FOLDER;
    private static final String PROFESIONAL_APPLICATION_FOLDER;
    private static final String CIUDADANO_LINK = "Tarjeta Virtual BakQ.lnk";
    private static final String PROFESIONAL_LINK = "Tarjeta Virtual Profesionales.lnk";

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
        USER_HOME = System.getProperty("user.home");
        DESKTOP_HOME = String.valueOf(USER_HOME) + FILE_SEPARATOR + "Desktop" + FILE_SEPARATOR;
        PROGRAMS_HOME = "C:" + FILE_SEPARATOR + "ProgramData" + FILE_SEPARATOR + "Microsoft" + FILE_SEPARATOR + "Windows" + FILE_SEPARATOR + "Start Menu" + FILE_SEPARATOR + "Programs" + FILE_SEPARATOR + "Izenpe" + FILE_SEPARATOR + "Izenpe" + FILE_SEPARATOR;
        LOG_FILE_PATH = String.valueOf(USER_HOME) + FILE_SEPARATOR + LOG_FILENAME;
        CIUDADANO_FILE_PATH = "vsc" + FILE_SEPARATOR + "ciudadano" + FILE_SEPARATOR;
        PROFESIONAL_FILE_PATH = "vsc" + FILE_SEPARATOR + "profesional" + FILE_SEPARATOR;
        CIUDADANO_APPLICATION_FOLDER = "C:" + FILE_SEPARATOR + "Program Files" + FILE_SEPARATOR + "izenpe" + FILE_SEPARATOR + "Tarjeta Virtual BakQ";
        PROFESIONAL_APPLICATION_FOLDER = "C:" + FILE_SEPARATOR + "Program Files" + FILE_SEPARATOR + "izenpe" + FILE_SEPARATOR + "Tarjeta Virtual Profesional";
    }

    private static void setGlobalProperties(String[] path) {
        ENTORNO = PropertiesReaderUtils.getInstance(path[0]).getProperty("vsc.entorno").toUpperCase();
        VERSION = PropertiesReaderUtils.getInstance(path[0]).getProperty("vsc.version");
        IDIOMA = PropertiesReaderUtils.getInstance(path[0]).getProperty("vsc.idioma");
        CIUDADANO_MSI_FILENAME = String.valueOf(CIUDADANO_FILE_PATH) + "TarjetaVirtualCiudadano-" + ENTORNO + "-" + VERSION + "-" + IDIOMA + ".msi";
        PROFESIONAL_MSI_FILENAME = String.valueOf(PROFESIONAL_FILE_PATH) + "TarjetaVirtualProfesional-" + ENTORNO + "-" + VERSION + "-" + IDIOMA + ".msi";
    }

    public static void main(String[] args) throws IOException {
        TarjetaVirtual.setGlobalProperties(args);
        Scanner scanner = new Scanner(System.in);
        System.out.println("Seleccione la opcion de Tarjeta Virtual que desea instalar:");
        System.out.println();
        System.out.println("1. Tarjeta Virtual Ciudadano");
        System.out.println("2. Tarjeta Virtual Profesional");
        System.out.println();
        System.out.print("Opcion: ");
        String opcion = scanner.nextLine();
        if ("1".equalsIgnoreCase(opcion)) {
            String line;
            System.out.println();
            System.out.println("Eliminando Tarjeta Virtual...");
            System.out.println();
            String path = TarjetaVirtual.getPath(args[0], PROFESIONAL_MSI_FILENAME);
            System.out.println("Ruta: " + path);
            ProcessBuilder builder = new ProcessBuilder(CMD_EXE, "/c", "msiexec /x \"" + args[0] + PROFESIONAL_MSI_FILENAME + "\" /quiet");
            builder.redirectErrorStream(true);
            Process p = builder.start();
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = r.readLine()) != null) {
                TarjetaVirtual.printMessage(line);
            }
            System.out.println("Instalando Tarjeta Virtual Ciudadano...");
            boolean tarjetaVirtualInstalled = false;
            path = TarjetaVirtual.getPath(args[0], CIUDADANO_MSI_FILENAME);
            System.out.println("Ruta: " + path);
            builder = new ProcessBuilder(CMD_EXE, "/c", "msiexec /i \"" + path + "\" /quiet /L*V " + LOG_FILE_PATH + " APPLICATIONFOLDER=\"" + CIUDADANO_APPLICATION_FOLDER + "\"");
            builder.redirectErrorStream(true);
            p = builder.start();
            r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int pos = 0;
            while (true) {
                if ((line = r.readLine()) == null) {
                    if (pos != 0) break;
                    tarjetaVirtualInstalled = true;
                    break;
                }
                ++pos;
                TarjetaVirtual.printMessage(line);
            }
            if (tarjetaVirtualInstalled) {
                System.out.println("Creando acceso directo de Tarjeta Virtual Ciudadano...");
                builder = new ProcessBuilder(CMD_EXE, "/c", "del \"" + DESKTOP_HOME + PROFESIONAL_LINK + "\"");
                builder.redirectErrorStream(true);
                p = builder.start();
                r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = r.readLine()) != null) {
                    TarjetaVirtual.printMessage(line);
                }
                builder = new ProcessBuilder(CMD_EXE, "/c", "copy \"" + PROGRAMS_HOME + CIUDADANO_LINK + "\" \"" + DESKTOP_HOME + CIUDADANO_LINK + "\"");
                builder.redirectErrorStream(true);
                p = builder.start();
                r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = r.readLine()) != null) {
                    TarjetaVirtual.printMessage(line);
                }
                System.out.println("Proceso finalizado con EXITO!");
                System.out.println();
                System.out.println("Es necesario reiniciar el equipo para evitar posibles conflictos");
            } else {
                System.out.println("Ha ocurrido un error durante el proceso!");
            }
        } else if ("2".equalsIgnoreCase(opcion)) {
            String line;
            System.out.println();
            System.out.println("Eliminado Tarjeta Virtual...");
            System.out.println();
            String path = TarjetaVirtual.getPath(args[0], CIUDADANO_MSI_FILENAME);
            System.out.println("Ruta: " + path);
            ProcessBuilder builder = new ProcessBuilder(CMD_EXE, "/c", "msiexec /x \"" + path + "\" /quiet");
            builder.redirectErrorStream(true);
            Process p = builder.start();
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = r.readLine()) != null) {
                TarjetaVirtual.printMessage(line);
            }
            System.out.println("Instalando Tarjeta Virtual Profesional...");
            boolean tarjetaVirtualInstalled = false;
            path = TarjetaVirtual.getPath(args[0], PROFESIONAL_MSI_FILENAME);
            System.out.println("Ruta: " + path);
            builder = new ProcessBuilder(CMD_EXE, "/c", "msiexec /i \"" + path + "\" /quiet /L*V " + LOG_FILE_PATH + " APPLICATIONFOLDER=\"" + PROFESIONAL_APPLICATION_FOLDER + "\"");
            builder.redirectErrorStream(true);
            p = builder.start();
            r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int pos = 0;
            while (true) {
                if ((line = r.readLine()) == null) {
                    if (pos != 0) break;
                    tarjetaVirtualInstalled = true;
                    break;
                }
                ++pos;
                TarjetaVirtual.printMessage(line);
            }
            if (tarjetaVirtualInstalled) {
                System.out.println("Creando acceso directo de Tarjeta Virtual Profesional...");
                builder = new ProcessBuilder(CMD_EXE, "/c", "del \"" + DESKTOP_HOME + CIUDADANO_LINK + "\"");
                builder.redirectErrorStream(true);
                p = builder.start();
                r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = r.readLine()) != null) {
                    TarjetaVirtual.printMessage(line);
                }
                builder = new ProcessBuilder(CMD_EXE, "/c", "copy \"" + PROGRAMS_HOME + PROFESIONAL_LINK + "\" \"" + DESKTOP_HOME + PROFESIONAL_LINK + "\"");
                builder.redirectErrorStream(true);
                p = builder.start();
                r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = r.readLine()) != null) {
                    TarjetaVirtual.printMessage(line);
                }
                System.out.println("Proceso finalizado con EXITO!");
                System.out.println();
                System.out.println("Es necesario reiniciar el equipo para evitar posibles conflictos");
            } else {
                System.out.println("Ha ocurrido un error durante el proceso!");
            }
        } else {
            scanner.close();
            System.out.print("Saliendo...");
            System.exit(0);
        }
    }

    private static String getPath(String path, String msiName) {
        return String.valueOf(path) + msiName;
    }

    private static void printMessage(String line) {
        if (line != null && !"".equals(line)) {
            System.out.println(line);
        }
    }
}

