/*
 * Decompiled with CFR 0.152.
 */
package eus.izenpe.midni.util;

import eus.izenpe.midni.model.MidniHolder;
import eus.izenpe.midni.model.constant.EstadoFirma;
import eus.izenpe.midni.model.constant.TagEtiquetaMensaje;
import eus.izenpe.midni.model.dto.DatosCabeceraValidacionDto;
import eus.izenpe.midni.model.dto.DatosCertificadoValidacionDto;
import eus.izenpe.midni.model.dto.DatosFirmaValidacionDto;
import eus.izenpe.midni.model.dto.DatosValidacionDto;
import eus.izenpe.midni.model.dto.ErrorValidacion;
import eus.izenpe.midni.model.dto.ItemMensajeValidacionDto;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;

public final class FirmaUtils {
    private static final String ALGORITMO_FIRMA = "SHA256withECDSA";
    private static final FirmaUtils INSTANCE = new FirmaUtils();

    public static FirmaUtils getInstance() {
        return INSTANCE;
    }

    private FirmaUtils() {
    }

    public void procesarFirma(DatosValidacionDto datos, MidniHolder holder, Optional<X509Certificate> optCertificate, List<ErrorValidacion> errores) {
        Optional<String> optFechaValidezDatos;
        boolean esDatosValidos;
        byte[] firmaBytes = holder.getFirma();
        String firmaB64 = Base64.getEncoder().encodeToString(firmaBytes);
        byte[] content = holder.getContenido();
        EstadoFirma estado = this.obtenerEstadoFirma(optCertificate, content, firmaBytes);
        if (!EstadoFirma.FIRMA_VERIFICADA.equals((Object)estado)) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.FIR_ESTADO_NOVALIDO, estado.name()));
        }
        if (esDatosValidos = this.esDatosValidos(optFechaValidezDatos = this.obtenerFechaValidezDatos(datos))) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.FIR_DATOS_NOVALIDOS, optFechaValidezDatos.orElse("<null>")));
        }
        this.procesarCertificado(datos, holder, optCertificate, errores);
        DatosFirmaValidacionDto firma = datos.getFirma();
        firma.setContenido(firmaB64);
        firma.setEstado(estado);
    }

    private void procesarCertificado(DatosValidacionDto datos, MidniHolder holder, Optional<X509Certificate> optCertificate, List<ErrorValidacion> errores) {
        if (!optCertificate.isPresent()) {
            return;
        }
        DatosCabeceraValidacionDto cabecera = datos.getCabecera();
        String referenciaCertificado = cabecera.getReferenciaCertificado();
        DatosFirmaValidacionDto firma = datos.getFirma();
        DatosCertificadoValidacionDto certificado = firma.getCertificado();
        X509Certificate x509Certificate = optCertificate.get();
        Principal subjectDN = x509Certificate.getSubjectDN();
        String dn = subjectDN.toString();
        certificado.setDn(dn);
        BigInteger serialBi = x509Certificate.getSerialNumber();
        String serialHex = serialBi.toString(16).toUpperCase();
        certificado.setSerial(serialHex);
        try {
            BigInteger referenciaCertificadoBi = new BigInteger(referenciaCertificado, 16);
            if (!referenciaCertificadoBi.equals(serialBi)) {
                errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.FIR_NUMSERIE_NOVALIDO));
            }
        }
        catch (Exception e) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.FIR_NUMSERIE_NOVALIDO, e.toString()));
        }
    }

    private EstadoFirma obtenerEstadoFirma(Optional<X509Certificate> optCertificate, byte[] contentBytes, byte[] signatureBytes) {
        boolean verified;
        Signature signature;
        if (!optCertificate.isPresent()) {
            return EstadoFirma.CERTIFICADO_NULO;
        }
        X509Certificate certificate = optCertificate.get();
        PublicKey publicKey = certificate.getPublicKey();
        if (!(publicKey instanceof ECPublicKey)) {
            return EstadoFirma.CLAVE_FIRMA_INCORRECTA;
        }
        try {
            signature = Signature.getInstance(ALGORITMO_FIRMA);
            signature.initVerify(publicKey);
            signature.update(contentBytes);
        }
        catch (NoSuchAlgorithmException e) {
            return EstadoFirma.ALGORITMO_FIRMA_NO_VALIDO;
        }
        catch (InvalidKeyException e) {
            return EstadoFirma.CLAVE_FIRMA_INCORRECTA;
        }
        catch (SignatureException e) {
            return EstadoFirma.ERROR_EN_FIRMA;
        }
        int signatureLength = signatureBytes.length;
        ASN1EncodableVector ans1verctor = new ASN1EncodableVector();
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(signatureBytes, 0, signatureLength / 2));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(signatureBytes, signatureLength / 2, signatureLength));
        ans1verctor.add((ASN1Encodable)new ASN1Integer(r));
        ans1verctor.add((ASN1Encodable)new ASN1Integer(s));
        DERSequence serSequence = new DERSequence(ans1verctor);
        try {
            verified = signature.verify(serSequence.getEncoded());
        }
        catch (SignatureException e) {
            return EstadoFirma.ERROR_EN_FIRMA;
        }
        catch (IOException e) {
            return EstadoFirma.ERROR_DE_LECTURA;
        }
        EstadoFirma estadoFirma = verified ? EstadoFirma.FIRMA_VERIFICADA : EstadoFirma.FIRMA_NO_VERIFICADA;
        return estadoFirma;
    }

    private Optional<String> obtenerFechaValidezDatos(DatosValidacionDto datos) {
        return datos.getMensaje().getItems().stream().filter(i -> i.getEtiqueta().getTag() == TagEtiquetaMensaje.FECHA_CADUCIDAD_DATOS).findFirst().map(ItemMensajeValidacionDto::getContenido);
    }

    private boolean esDatosValidos(Optional<String> optFechaFinValidezStr) {
        Date fechaFinValidez;
        if (!optFechaFinValidezStr.isPresent()) {
            return false;
        }
        String fechaFinValidezStr = optFechaFinValidezStr.get();
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("DD-MM-YYYY HH:mm:ss");
            fechaFinValidez = dateFormat.parse(fechaFinValidezStr);
        }
        catch (Exception e) {
            return false;
        }
        Date now = Calendar.getInstance().getTime();
        return now.before(fechaFinValidez);
    }
}

