/*
 * Decompiled with CFR 0.152.
 */
package eus.izenpe.midni.util;

import eus.izenpe.midni.exception.InterrupcionStreamException;
import eus.izenpe.midni.model.MidniHolder;
import eus.izenpe.midni.model.constant.TagEtiquetaMensaje;
import eus.izenpe.midni.model.dto.DatosMensajeValidacionDto;
import eus.izenpe.midni.model.dto.ErrorValidacion;
import eus.izenpe.midni.model.dto.EtiquetaItemMensajeValidacionDto;
import eus.izenpe.midni.model.dto.ItemMensajeValidacionDto;
import eus.izenpe.midni.util.ByteDecodeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ExtraccionMensajeUtils {
    private static final ExtraccionMensajeUtils INSTANCE = new ExtraccionMensajeUtils();

    public static ExtraccionMensajeUtils getInstance() {
        return INSTANCE;
    }

    private ExtraccionMensajeUtils() {
    }

    public void procesarMensaje(InputStream stream, MidniHolder holder, DatosMensajeValidacionDto mensaje, List<ErrorValidacion> errores) {
        List<ItemMensajeValidacionDto> items = mensaje.getItems();
        while (true) {
            ItemMensajeValidacionDto item = new ItemMensajeValidacionDto();
            this.procesarItem(stream, holder, item, errores);
            EtiquetaItemMensajeValidacionDto etiqueta = item.getEtiqueta();
            TagEtiquetaMensaje tag = etiqueta.getTag();
            if (TagEtiquetaMensaje.FIRMA.equals((Object)tag)) break;
            items.add(item);
        }
    }

    private int obtenerTamagnoEtiqueta(InputStream stream, MidniHolder holder, TagEtiquetaMensaje tag) throws IOException {
        boolean esFirma = TagEtiquetaMensaje.FIRMA.equals((Object)tag);
        int first = stream.read();
        if (!esFirma) {
            holder.addContenido(new byte[]{(byte)first});
        }
        if (first < 0) {
            throw new IOException("EOF leyendo longitud TLV");
        }
        if ((first & 0x80) == 0) {
            return first;
        }
        int numBytes = first & 0x7F;
        if (numBytes == 0 || numBytes > 4) {
            throw new IOException("Longitud TLV no soportada: " + numBytes + " bytes");
        }
        int length = 0;
        for (int i = 0; i < numBytes; ++i) {
            int b = stream.read();
            if (!esFirma) {
                holder.addContenido(new byte[]{(byte)b});
            }
            if (b < 0) {
                throw new IOException("EOF leyendo longitud extendida TLV");
            }
            length = length << 8 | b & 0xFF;
        }
        return length;
    }

    private void procesarItem(InputStream stream, MidniHolder holder, ItemMensajeValidacionDto item, List<ErrorValidacion> errores) {
        this.procesarEtiqueta(stream, holder, item, errores);
        this.procesarTamagno(stream, holder, item, errores);
        this.procesarContenido(stream, holder, item, errores);
    }

    private void procesarContenido(InputStream stream, MidniHolder holder, ItemMensajeValidacionDto item, List<ErrorValidacion> errores) {
        byte[] bytes;
        int tamagno = item.getTamagno();
        EtiquetaItemMensajeValidacionDto etiqueta = item.getEtiqueta();
        String hex = etiqueta.getHex();
        TagEtiquetaMensaje tag = etiqueta.getTag();
        Function<byte[], String> parser = tag.getParser();
        Predicate<String> validator = tag.getValidator();
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, tamagno);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Mensaje.Item." + etiqueta + ": " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        String contenido = parser.apply(bytes);
        boolean isValid = validator.test(contenido);
        item.setContenido(contenido);
        if (!isValid) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.MSG_CONTENIDO_NOVALIDO, hex));
        }
        if (TagEtiquetaMensaje.FIRMA.equals((Object)tag)) {
            holder.addFirma(bytes);
        } else {
            holder.addContenido(bytes);
        }
    }

    private void procesarEtiqueta(InputStream stream, MidniHolder holder, ItemMensajeValidacionDto item, List<ErrorValidacion> errores) {
        String hex;
        byte[] bytes;
        EtiquetaItemMensajeValidacionDto etiqueta = item.getEtiqueta();
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, 1);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Mensaje.Item.Etiqueta: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            hex = ByteDecodeUtils.getInstance().bytes2str(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.BYTES2STR_EXCEPTION, "Mensaje.Item.Etiqueta: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        etiqueta.setHex(hex);
        TagEtiquetaMensaje tag = TagEtiquetaMensaje.getByCode(hex);
        if (Arrays.asList(TagEtiquetaMensaje.NULL, TagEtiquetaMensaje.UNKNOWN).contains((Object)tag)) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.MSG_HEX_NORECONOCIDO, hex));
        }
        etiqueta.setTag(tag);
        if (!TagEtiquetaMensaje.FIRMA.equals((Object)tag)) {
            holder.addContenido(bytes);
        }
    }

    private void procesarTamagno(InputStream stream, MidniHolder holder, ItemMensajeValidacionDto item, List<ErrorValidacion> errores) {
        try {
            EtiquetaItemMensajeValidacionDto etiqueta = item.getEtiqueta();
            TagEtiquetaMensaje tag = etiqueta.getTag();
            int tamagno = this.obtenerTamagnoEtiqueta(stream, holder, tag);
            item.setTamagno(tamagno);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Mensaje.Item.Etiqueta: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
    }
}

