/*
 * Decompiled with CFR 0.152.
 */
package eus.izenpe.midni.util;

import java.util.ArrayList;
import java.util.Iterator;

public final class C40DecodeUtils {
    private static final char[] BASIC = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] SHIFT2 = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static C40DecodeUtils INSTANCE = new C40DecodeUtils();

    public static C40DecodeUtils getInstance() {
        return INSTANCE;
    }

    private C40DecodeUtils() {
    }

    public String decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public String decode(byte[] bytes, int off, int len) {
        ArrayList<Integer> triples = new ArrayList<Integer>(len / 2 * 3);
        int end = off + (len & 0xFFFFFFFE);
        for (int idx = off; idx < end; idx += 2) {
            int b1 = bytes[idx] & 0xFF;
            int b2 = bytes[idx + 1] & 0xFF;
            int v = (b1 << 8) + b2 - 1;
            int c1 = v / 1600;
            int r1 = v % 1600;
            int c2 = r1 / 40;
            int c3 = r1 % 40;
            triples.add(c1);
            triples.add(c2);
            triples.add(c3);
        }
        StringBuilder stringBuilder = new StringBuilder(triples.size());
        boolean upperShift = false;
        int shift = 0;
        Iterator iterator = triples.iterator();
        block7: while (iterator.hasNext()) {
            int triplet = (Integer)iterator.next();
            switch (shift) {
                case 0: {
                    if (triplet < 3) {
                        shift = triplet + 1;
                        continue block7;
                    }
                    if (triplet < 40) {
                        char ch = BASIC[triplet];
                        if (upperShift) {
                            ch = (char)(ch + 128);
                            upperShift = false;
                        }
                        stringBuilder.append(ch);
                        continue block7;
                    }
                    stringBuilder.append('?');
                    continue block7;
                }
                case 1: {
                    char ch1 = (char)triplet;
                    if (upperShift) {
                        ch1 = (char)(ch1 + 128);
                        upperShift = false;
                    }
                    stringBuilder.append(ch1);
                    shift = 0;
                    continue block7;
                }
                case 2: {
                    if (triplet < SHIFT2.length) {
                        char ch2 = SHIFT2[triplet];
                        if (upperShift) {
                            ch2 = (char)(ch2 + 128);
                            upperShift = false;
                        }
                        stringBuilder.append(ch2);
                    } else if (triplet != 27) {
                        if (triplet == 30) {
                            upperShift = true;
                        } else {
                            stringBuilder.append('?');
                        }
                    }
                    shift = 0;
                    continue block7;
                }
                case 3: {
                    if (triplet < 26) {
                        char ch3 = (char)(97 + triplet);
                        if (upperShift) {
                            ch3 = (char)(ch3 + 128);
                            upperShift = false;
                        }
                        stringBuilder.append(ch3);
                    } else {
                        stringBuilder.append('?');
                    }
                    shift = 0;
                    continue block7;
                }
            }
            stringBuilder.append('?');
            shift = 0;
        }
        return stringBuilder.toString();
    }

    public int calculateByteSize(int sizeInt) {
        return (sizeInt + 2) / 3 * 2;
    }
}

