/*
 * Decompiled with CFR 0.152.
 */
package eus.izenpe.midni.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ByteDecodeUtils {
    private static final ByteDecodeUtils INSTANCE = new ByteDecodeUtils();

    public static ByteDecodeUtils getInstance() {
        return INSTANCE;
    }

    private ByteDecodeUtils() {
    }

    public Date bytes2Date(byte[] fechaBytes) {
        long fechaLong = ByteDecodeUtils.getInstance().bytes2long(fechaBytes);
        int year = Long.valueOf(fechaLong % 10000L).intValue();
        int day = Long.valueOf(fechaLong / 10000L % 100L).intValue() - 1;
        int month = Long.valueOf(fechaLong / 1000000L % 100L).intValue() - 1;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public Long bytes2long(byte[] bytes) {
        String hex = this.bytes2str(bytes);
        String hexWithout0x = hex.substring(2);
        return Long.parseLong(hexWithout0x, 16);
    }

    public String byte2str(byte b) {
        return String.format("%02X", b & 0xFF);
    }

    public String bytes2str(byte[] bytes) {
        return IntStream.range(0, bytes.length).mapToObj(i -> bytes[i]).map(this::byte2str).collect(Collectors.joining("", "0x", ""));
    }

    public byte[] readBytes(InputStream stream, int size) throws IOException {
        int read;
        byte[] buff = new byte[size];
        for (int offset = 0; offset < size; offset += read) {
            read = stream.read(buff, offset, size - offset);
            if (read >= 0) continue;
            throw new IOException("EOF antes de leer los " + size + " bytes esperados");
        }
        return buff;
    }
}

