/*
 * Decompiled with CFR 0.152.
 */
package eus.izenpe.midni;

import eus.izenpe.midni.config.ValidadorConfig;
import eus.izenpe.midni.config.ValidadorConfigCertPublicoData;
import eus.izenpe.midni.model.MidniHolder;
import eus.izenpe.midni.model.dto.ErrorValidacion;
import eus.izenpe.midni.model.dto.RespuestaValidacionDto;
import eus.izenpe.midni.util.CertificadoReaderUtils;
import eus.izenpe.midni.util.ExtraccionUtils;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;

public class Validador {
    private final ValidadorConfig config;

    private static RespuestaValidacionDto prepararRespuestaError(ErrorValidacion ... errores) {
        RespuestaValidacionDto dto = new RespuestaValidacionDto();
        dto.setErrores(Arrays.asList(errores));
        return dto;
    }

    public Validador(ValidadorConfig config) {
        this.config = config;
    }

    public RespuestaValidacionDto validar(String b64) {
        byte[] bytes;
        try {
            bytes = Base64.getDecoder().decode(b64);
        }
        catch (Exception e) {
            return Validador.prepararRespuestaError(ErrorValidacion.from(ErrorValidacion.Tipo.B64_NO_VALIDO));
        }
        return this.validar(bytes);
    }

    public RespuestaValidacionDto validar(byte[] bytes) {
        MidniHolder holder = new MidniHolder();
        ValidadorConfigCertPublicoData certPublico = this.config.getCertPublico();
        Optional<X509Certificate> optCertificate = CertificadoReaderUtils.getInstance().obtenerCertificado(certPublico);
        return ExtraccionUtils.getInstance().extraerDatos(bytes, holder, optCertificate);
    }
}

