/*
 * Decompiled with CFR 0.152.
 */
package eus.izenpe.midni.util;

import eus.izenpe.midni.exception.InterrupcionStreamException;
import eus.izenpe.midni.model.MidniHolder;
import eus.izenpe.midni.model.dto.DatosCabeceraValidacionDto;
import eus.izenpe.midni.model.dto.DatosMensajeValidacionDto;
import eus.izenpe.midni.model.dto.DatosValidacionDto;
import eus.izenpe.midni.model.dto.ErrorValidacion;
import eus.izenpe.midni.model.dto.RespuestaValidacionDto;
import eus.izenpe.midni.util.ExtraccionCabeceraUtils;
import eus.izenpe.midni.util.ExtraccionMensajeUtils;
import eus.izenpe.midni.util.FirmaUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;

public final class ExtraccionUtils {
    private static final ExtraccionUtils INSTANCE = new ExtraccionUtils();

    public static ExtraccionUtils getInstance() {
        return INSTANCE;
    }

    public RespuestaValidacionDto extraerDatos(byte[] bytes, MidniHolder holder, Optional<X509Certificate> optCertificate) {
        RespuestaValidacionDto respuesta = new RespuestaValidacionDto();
        List<ErrorValidacion> errores = respuesta.getErrores();
        DatosValidacionDto datos = respuesta.getDatos();
        DatosCabeceraValidacionDto cabecera = datos.getCabecera();
        DatosMensajeValidacionDto mensaje = datos.getMensaje();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            ExtraccionCabeceraUtils.getInstance().procesarCabecera(stream, holder, cabecera, errores);
            ExtraccionMensajeUtils.getInstance().procesarMensaje(stream, holder, mensaje, errores);
        }
        catch (InterrupcionStreamException e) {
            ErrorValidacion error = e.getError();
            errores.add(error);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, e.toString());
            errores.add(error);
        }
        FirmaUtils.getInstance().procesarFirma(datos, holder, optCertificate, errores);
        return respuesta;
    }
}

