/*
 * Decompiled with CFR 0.152.
 */
package eus.izenpe.midni.util;

import eus.izenpe.midni.exception.InterrupcionStreamException;
import eus.izenpe.midni.model.MidniHolder;
import eus.izenpe.midni.model.constant.CategoriaTipoDocumento;
import eus.izenpe.midni.model.constant.Referencia;
import eus.izenpe.midni.model.constant.Version;
import eus.izenpe.midni.model.dto.DatosCabeceraValidacionDto;
import eus.izenpe.midni.model.dto.ErrorValidacion;
import eus.izenpe.midni.util.ByteDecodeUtils;
import eus.izenpe.midni.util.C40DecodeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class ExtraccionCabeceraUtils {
    private static final String VALID_MAGIC_CONSTANT = "0xDC";
    private static final String ESPAGNA = "ES";
    private static final ExtraccionCabeceraUtils INSTANCE = new ExtraccionCabeceraUtils();

    public static ExtraccionCabeceraUtils getInstance() {
        return INSTANCE;
    }

    private ExtraccionCabeceraUtils() {
    }

    public void procesarCabecera(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        this.procesarMagicNumber(stream, holder, cabecera, errores);
        this.procesarVersion(stream, holder, cabecera, errores);
        this.procesarPais(stream, holder, cabecera, errores);
        this.procesarIdentificadorFirmante(stream, holder, cabecera, errores);
        this.procesarReferenciaCertificado(stream, holder, cabecera, errores);
        this.procesarFechaEmision(stream, holder, cabecera, errores);
        this.procesarFechaFirma(stream, holder, cabecera, errores);
        this.procesarReferencia(stream, holder, cabecera, errores);
        this.procesarCategoriaTipoDocumento(stream, holder, cabecera, errores);
    }

    private void procesarCategoriaTipoDocumento(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        Long categoriaLong;
        byte[] bytes;
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, 1);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Cabecera.CategoriaTipoDocumento: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            categoriaLong = ByteDecodeUtils.getInstance().bytes2long(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.BYTES2LONG_EXCEPTION, "Cabecera.CategoriaTipoDocumento: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        CategoriaTipoDocumento categoria = CategoriaTipoDocumento.getByCode(categoriaLong);
        if (CategoriaTipoDocumento.DNI_ES_MOVIL != categoria) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.CAB_CATTIPODOCUMENTO_NOVALIDA, String.valueOf(categoriaLong)));
        }
        cabecera.setCategoriaDocumento(categoria);
        holder.addContenido(bytes);
    }

    private void procesarFechaEmision(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        Date fecha;
        byte[] bytes;
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, 3);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Cabecera.FechaEmision: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            fecha = ByteDecodeUtils.getInstance().bytes2Date(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.BYTES2DATE_EXCEPTION, "Cabecera.FechaEmision: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        cabecera.setFechaEmision(fecha);
        holder.addContenido(bytes);
    }

    private void procesarFechaFirma(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        Date fecha;
        byte[] bytes;
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, 3);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Cabecera.FechaFirma: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            fecha = ByteDecodeUtils.getInstance().bytes2Date(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.BYTES2DATE_EXCEPTION, "Cabecera.FechaFirma: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        cabecera.setFechaFirma(fecha);
        holder.addContenido(bytes);
    }

    private void procesarIdentificadorFirmante(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        String identificadorStr;
        byte[] bytes;
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, 4);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Cabecera.IdentificadorFirmante: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            identificadorStr = C40DecodeUtils.getInstance().decode(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.C40_EXCEPTION, "Cabecera.IdentificadorFirmante: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        cabecera.setIdentificadorFirmante(identificadorStr);
        holder.addContenido(bytes);
    }

    private void procesarMagicNumber(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        String magicConstantStr;
        byte[] bytes;
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, 1);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Cabecera.MagicConstant: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            magicConstantStr = ByteDecodeUtils.getInstance().bytes2str(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.BYTES2STR_EXCEPTION, "Cabecera.MagicConstant: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        if (!VALID_MAGIC_CONSTANT.equals(magicConstantStr)) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.CAB_MAGICCONSTANT_NOVALIDA, magicConstantStr));
        }
        cabecera.setMagicNumber(magicConstantStr);
        holder.addContenido(bytes);
    }

    private void procesarPais(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        String paisStr;
        byte[] bytes;
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, 2);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Cabecera.Pais: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            paisStr = C40DecodeUtils.getInstance().decode(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.C40_EXCEPTION, "Cabecera.Pais: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        if (!ESPAGNA.equals(paisStr)) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.CAB_PAIS_NOVALIDA, paisStr));
        }
        cabecera.setPais(paisStr);
        holder.addContenido(bytes);
    }

    private void procesarReferencia(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        Long referenciaLong;
        byte[] bytes;
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, 1);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Cabecera.Referencia: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            referenciaLong = ByteDecodeUtils.getInstance().bytes2long(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.BYTES2LONG_EXCEPTION, "Cabecera.Referencia: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        Referencia referencia = Referencia.getByCode(referenciaLong);
        if (!Arrays.asList(Referencia.COMPLETA, Referencia.SIMPLE, Referencia.MAYORIA_EDAD).contains((Object)referencia)) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.CAB_REFERENCIA_NOVALIDA, String.valueOf(referenciaLong)));
        }
        cabecera.setReferencia(referencia);
        holder.addContenido(bytes);
    }

    private void procesarReferenciaCertificado(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        String referencia;
        byte[] bytes;
        int bytesSize;
        String identificadorStr = cabecera.getIdentificadorFirmante();
        if (identificadorStr == null) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.CAB_IDENTIFICADORFIRMANTE_NOVALIDA, identificadorStr);
            throw new InterrupcionStreamException(error);
        }
        try {
            String sizeHex = identificadorStr.substring(4);
            int sizeInt = Integer.parseInt(sizeHex, 16);
            bytesSize = C40DecodeUtils.getInstance().calculateByteSize(sizeInt);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.CAB_IDENTIFICADORFIRMANTE_NOVALIDA, "Obtener bytes referencia");
            throw new InterrupcionStreamException(error);
        }
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, bytesSize);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Cabecera.ReferenciaCertificado: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            referencia = C40DecodeUtils.getInstance().decode(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.C40_EXCEPTION, "Cabecera.ReferenciaCertificado: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        cabecera.setReferenciaCertificado(referencia);
        holder.addContenido(bytes);
    }

    private void procesarVersion(InputStream stream, MidniHolder holder, DatosCabeceraValidacionDto cabecera, List<ErrorValidacion> errores) {
        String versionStr;
        byte[] bytes;
        try {
            bytes = ByteDecodeUtils.getInstance().readBytes(stream, 1);
        }
        catch (IOException e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.IO_EXCEPTION, "Cabecera.Version: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        try {
            versionStr = ByteDecodeUtils.getInstance().bytes2str(bytes);
        }
        catch (Exception e) {
            ErrorValidacion error = ErrorValidacion.from(ErrorValidacion.Tipo.BYTES2STR_EXCEPTION, "Cabecera.Version: " + e.toString());
            throw new InterrupcionStreamException(error);
        }
        Version version = Version.getByCode(versionStr);
        if (version != Version.V04) {
            errores.add(ErrorValidacion.from(ErrorValidacion.Tipo.CAB_VERSION_NOVALIDA, versionStr));
        }
        cabecera.setVersion(version);
        holder.addContenido(bytes);
    }
}

