/*
 * Decompiled with CFR 0.152.
 */
package eus.izenpe.midni.util;

import eus.izenpe.midni.config.ValidadorConfigCertPublicoData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Optional;

public final class CertificadoReaderUtils {
    private static CertificadoReaderUtils INSTANCE = new CertificadoReaderUtils();

    public static CertificadoReaderUtils getInstance() {
        return INSTANCE;
    }

    private CertificadoReaderUtils() {
    }

    public Optional<X509Certificate> obtenerCertificado(ValidadorConfigCertPublicoData certPublico) {
        ValidadorConfigCertPublicoData.Modo modo = certPublico.getModo();
        switch (modo) {
            case PATH: {
                return this.obtenerCertificadoPorPath(certPublico);
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<X509Certificate> obtenerCertificadoPorBytes(byte[] bytes) {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            return Optional.empty();
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            Optional<X509Certificate> optional = Optional.ofNullable(certificate);
            return optional;
        }
        catch (IOException | CertificateException e) {
            return Optional.empty();
        }
    }

    private Optional<X509Certificate> obtenerCertificadoPorPath(ValidadorConfigCertPublicoData certPublico) {
        byte[] bytes;
        try {
            String valor = certPublico.getValor();
            Path path = Paths.get(valor, new String[0]);
            bytes = Files.readAllBytes(path);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        return this.obtenerCertificadoPorBytes(bytes);
    }
}

