/*
 * Decompiled with CFR 0.152.
 */
package eus.izenpe.midni.model.constant;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Function;
import java.util.function.Predicate;

public enum TagEtiquetaMensaje {
    NUMERO_DOCUMENTO("0x40", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    FECHA_NACIMIENTO("0x42", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::isShortDate),
    NOMBRE("0x44", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    APELLIDOS("0x46", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    SEXO("0x48", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::isGender),
    FECHA_CADUCIDAD_DOCUMENTO("0x4C", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::isShortDate),
    IMAGEN("0x50", TagEtiquetaMensaje::bytes2b64, TagEtiquetaMensaje::alwaysValid),
    DIRECCION_COMPLETA("0x60", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    DOMICILIO_LINEA_1("0x72", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    DOMICILIO_LINEA_2("0x74", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    DOMICILIO_LINEA_3("0x76", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    LUGAR_NACIMIENTO_LINEA_1("0x62", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    LUGAR_NACIMIENTO_LINEA_2("0x78", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    LUGAR_NACIMIENTO_LINEA_3("0x7A", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    NACIONALIDAD("0x64", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    PADRES("0x66", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    NUMERO_SOPORTE("0x68", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    MAYOR_EDAD("0x70", TagEtiquetaMensaje::bytes2boolean, TagEtiquetaMensaje::isBoolean),
    FECHA_CADUCIDAD_DATOS("0x80", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::isLongDate),
    FIRMA("0xFF", TagEtiquetaMensaje::bytes2b64, TagEtiquetaMensaje::alwaysValid),
    NULL("NULL", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid),
    UNKNOWN("UNKNOWN", TagEtiquetaMensaje::bytes2string, TagEtiquetaMensaje::alwaysValid);

    private final String code;
    private final Function<byte[], String> parser;
    private final Predicate<String> validator;

    private static String bytes2b64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private static String bytes2boolean(byte[] bytes) {
        return Boolean.toString(1 == bytes[0]);
    }

    private static String bytes2string(byte[] bytes) {
        return new String(bytes);
    }

    private static boolean alwaysValid(String str) {
        return true;
    }

    private static boolean isBoolean(String str) {
        return Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()).contains(str);
    }

    private static boolean isGender(String str) {
        return Arrays.asList("F", "M").contains(str);
    }

    private static boolean isLongDate(String str) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("DD-MM-YYYY HH:mm:ss");
            dateFormat.parse(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isShortDate(String str) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("DD-MM-YYYY");
            dateFormat.parse(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static TagEtiquetaMensaje getByCode(String code) {
        if (code == null) {
            return NULL;
        }
        for (TagEtiquetaMensaje item : TagEtiquetaMensaje.values()) {
            if (!item.code.equals(code)) continue;
            return item;
        }
        return UNKNOWN;
    }

    private TagEtiquetaMensaje(String code, Function<byte[], String> parser, Predicate<String> validator) {
        this.code = code;
        this.parser = parser;
        this.validator = validator;
    }

    public String getCode() {
        return this.code;
    }

    public Function<byte[], String> getParser() {
        return this.parser;
    }

    public Predicate<String> getValidator() {
        return this.validator;
    }
}

