package com.ejie.r01m.test.search;

import r01f.util.types.Strings;
import r01mo.model.oids.typo.R01MTypoClusterOID;
import r01mo.model.oids.typo.R01MTypoFamilyOID;
import r01mo.model.oids.typo.R01MTypoTypeOID;
import r01mo.model.search.query.R01MSearchQuery;
import r01mo.model.search.query.metadata.R01MSearchQueryNumberMetaData;
import r01mo.model.search.query.metadata.R01MSearchQueryNumberMetaDataCondition;
import r01mo.model.search.query.metadata.R01MSearchQueryOrderByMetaData;
import r01mo.model.search.query.metadata.R01MSearchQueryOrderByMetaData.R01MSearchQueryOrderBy;

import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;

public class TestSearch {
	public static void main(String[] args) {
		try {
			// Construir la query
			R01MSearchQuery qry = _buildQuery();
			
			// Inicializar la sesin
			R01MSearchSession session = R01MSearchSession.forQuery(qry);
			
			System.out.println(session.queryAsURL());
			
			// Un poco de debug
			String dbg = Strings.create().add("[Resultados de la bsqueda: \r\n")
										 .add("\t- query como XML: ").addLine(session.queryAsXML())
										 .add("\t- query codificada en la URL: ").addLine(session.queryAsURL())
										 .add("\t- Resumen de la ejecucin: {} resultados en {} pginas de {} items (max) cada una").customizeWith(session.getPager().getTotalNumberOfItems(),
												 																							       session.getPager().getPageCount(),
												 																							       session.getPager().getPageSize())
										 .asString();
			System.out.println(dbg);
			
			// Recoger resultados
			R01MSearchResultItem[] resultItems = session.getCurrentPageSearchResults();
			System.out.println(_debugResultItems(resultItems));
			
			// Ir a la siguiente pgina de resultados
			resultItems = session.goToNextPage();
			System.out.println(_debugResultItems(resultItems));
			
		} catch (Exception ex) {
			ex.printStackTrace(System.out);
		}
	}
	private static R01MSearchQuery _buildQuery() {
		R01MSearchQuery qry = R01MSearchQuery.create()
											 .typedInAnyOfTheeseClusters(R01MTypoClusterOID.forId("euskadi"))
											 .typedInAnyOfTheeseFamilies(R01MTypoFamilyOID.forId("procedimientos_administrativos"))
											 .typedInAnyOfTheeseTypes(R01MTypoTypeOID.forId("ayuda_subvencion"))
											 .mustMeetTheeseMetaDataConditions(R01MSearchQueryNumberMetaData.forMetaData("procedureStatus")
													 													    .usingCondition(R01MSearchQueryNumberMetaDataCondition.EQUALS)
													 													    .with(16))
											 .mustHaveStructureLabel("label1")
											 .orderedBy(R01MSearchQueryOrderByMetaData.forMetaData("createDate")
													 								  .order(R01MSearchQueryOrderBy.ASCENDING));

		return qry;
	}
	private static String _debugResultItems(final R01MSearchResultItem[] items) {
		StringBuffer dbg = new StringBuffer();
		if (items != null) {
			for (R01MSearchResultItem item : items) {
				dbg.append("-").append(item.getContentName()).append(": ").append(item.getDocumentName()).append("\r\n");
			}
		}
		return dbg.toString();
	}
}
