/*
 * Created on Sep 5, 2005
 *
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.utils.searchengine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.utils.R01MConstants;


/**
 * Constantes para R01M
 */
public class R01MSearchEngineConstants {
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    // Tipologa de los objetos indexables para el indexador
//    public static final int INDEXABLEOBJECT_CONTENT = 1;
//    public static final int INDEXABLEOBJECT_DOCUMENT = 2;
//    public static final int INDEXABLEOBJECT_DATAFILE = 3;

    // Constantes que especifican los diferentes operadores que se
    // pueden aplicar para realizar el filtrado de datos en el buscador
    public static final String EQUALS_OPERATOR = "EQ";
    public static final String LESS_THAN_OPERATOR = "LT";
    public static final String GREATER_THAN_OPERATOR = "GT";
    public static final String LESS_THAN_OR_EQUAL_TO_OPERATOR = "LTE";
    public static final String GREATER_THAN_OR_EQUAL_TO_OPERATOR = "GTE";
    public static final String GREATER_THAN_OR_EQUAL_OR_NULL_TO_OPERATOR = "GTEN";
    public static final String NOT_EQUAL_TO_OPERATOR = "NEQ";
    public static final String LIKE_OPERATOR = "LIKE";
    public static final String STARTS_WITH_OPERATOR = "BEGINNING";
    public static final String ENDS_WITH_OPERATOR = "ENDING";
    public static final String BETWEEN_OPERATOR = "BETWEEN";
    public static final String ANY_OPERATOR = "ANY";
    public static final String ALL_OPERATOR = "ALL";
    public static final String LAST_OPERATOR = "LAST";
    public static final String NEXT_OPERATOR = "NEXT";
    public static final String IN_OPERATOR = "IN";


    // Separador utilizado para los valores de una condicin BETWEEN
    public static final String BETWEEN_VALUES_SEPARATOR = ",";
    public static final String IN_VALUES_SEPARATOR = ",";

    public static final String DEFAULT_DATE_FORMAT = "dd/MM/yyyy";

    // Constantes para indicar el tipo de operacin en el indexador
    public static final int INDEXER_INDEX_AND_PUBLISH = 2;
    public static final int INDEXER_INDEX = 1;
    public static final int INDEXER_UNINDEX = 0;

    // Formato de las fechas en la plantilla de captura
    public static final Properties DATACAPTURE_DATE_FORMATS = XMLProperties.getProperties(R01MConstants.API_APPCODE,
                                                                                          "searchEngine/dateFormats/dataCapture");
    // Formato de las fechas en la base de datos del buscador
    public static final Properties IDX_DATE_FORMATS = XMLProperties.getProperties(R01MConstants.API_APPCODE,
                                                                                  "searchEngine/dateFormats/indexableContent");
    // Formato de las fechas en las queries
    public static final Properties QUERY_DATE_FORMATS = XMLProperties.getProperties(R01MConstants.API_APPCODE,
                                                                                    "searchEngine/dateFormats/query");
    // Formato de las fechas en los resultados de busqueda
    public static final Properties SEARCHRESULT_DATE_FORMATS = XMLProperties.getProperties(R01MConstants.API_APPCODE,
                                                                                           "searchEngine/dateFormats/searchResult");
    // Formato de las fechas en presentacion
    public static final Properties PRESENTATION_DATE_FORMATS = XMLProperties.getProperties(R01MConstants.API_APPCODE,
                                                                                           "searchEngine/dateFormats/presentation");

    // Propiedades de la presentacin de resultados de bsqueda
    public static final String PRESENTATION_PROPERTY_THUMBNAILTYPE = "thumbNailType";
    public static final String PRESENTATION_PROPERTY_MAXNUMHIGHLIGHT = "maxNumHighLightsValue";
    public static final String PRESENTATION_PROPERTY_HIGHLIGHT_NOSCRIPT_TEXT = "highlightedNoScriptText";
    public static final String PRESENTATION_PROPERTY_HIGHLIGHT_NOSCRIPT_TITLE = "highlightedNoScriptTitle";
    public static final String PRESENTATION_PROPERTY_VALUE_NAME = "vaName";
    public static final String PRESENTATION_PROPERTY_RSS_TITLE = "rssTitle";

    /** Mapas de variables para los nombres de los ficheros de indexacin para contenidos y paginas de portal */
    public static final Map CONTENT_TYPE_NAMES;
    public static final Map PORTAL_TYPE_NAMES;
    static {    // Inicializacin de los operadores sobre metaDatos
        NodeIterator typeNameIterator = XMLProperties.getPropertyNodeIterator(R01MConstants.SEARCHENGINE_APPCODE,"objectTypeNames/contentTypeNames/typeName");
        CONTENT_TYPE_NAMES = new HashMap();
        if (typeNameIterator != null) {
            Node currDNINode = typeNameIterator.nextNode();
            while (currDNINode != null) {
                CONTENT_TYPE_NAMES.put(currDNINode.getAttributes().getNamedItem("oid").getNodeValue(),currDNINode.getFirstChild().getNodeValue());
                currDNINode = typeNameIterator.nextNode();
            }
        }

        typeNameIterator = XMLProperties.getPropertyNodeIterator(R01MConstants.SEARCHENGINE_APPCODE,"objectTypeNames/portalTypeNames/typeName");
        PORTAL_TYPE_NAMES = new HashMap();
        if (typeNameIterator != null) {
            Node currDNINode = typeNameIterator.nextNode();
            while (currDNINode != null) {
                PORTAL_TYPE_NAMES.put(currDNINode.getAttributes().getNamedItem("oid").getNodeValue(),currDNINode.getFirstChild().getNodeValue());
                currDNINode = typeNameIterator.nextNode();
            }
        }
    }

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MSearchEngineConstants() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////


}
