/*
 * Created on March 16, 2009
 */

package com.ejie.r01m.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

import com.ejie.r01f.util.StringUtils;

/**
 * Utilidades de tratamiento de ficheros excel.
 */	
public abstract class R01MExcelUtils {

 // /////////////////////////////////////////////////////////////////////////////////////////
 // CONSTANTES
 // /////////////////////////////////////////////////////////////////////////////////////////
    /**
     * N de la columna del nombre del servidor del contenido en el fichero excel para la recatalogacion masiva de contenidos
     */
    public static final int COLUMN_RECATALOG_CONTENT_SERVER = 0;
    /**
     * N de la columna del DataStore del contenido en el fichero excel para la recatalogacion masiva de contenidos
     */
    public static final int COLUMN_RECATALOG_CONTENT_DATASTORE = 1;
    /**
     * N de la columna del Area del contenido en el fichero excel para la recatalogacion masiva de contenidos
     */
    public static final int COLUMN_RECATALOG_CONTENT_AREA = 2;
    /**
     * N de la columna del Workarea del contenido en el fichero excel para la recatalogacion masiva de contenidos
     */
    public static final int COLUMN_RECATALOG_CONTENT_WORKAREA = 3;
    /**
     * N de la columna del GUID del contenido en el fichero excel para la recatalogacion masiva de contenidos
     */
    public static final int COLUMN_RECATALOG_CONTENT_GUID = 4;
    /**
     * N de la  columna del nombre del contenido en el fichero excel para la recatalogacion masiva de contenidos
     */
    public static final int COLUMN_RECATALOG_CONTENT_NAME = 5;
    /**
     * N de la columna del Cluster en el fichero excel para la recatalogacion masiva de contenidos
      */
     public static final int COLUMN_RECATALOG_CONTENT_CLUSTER = 6;
     /**
     * N de la columna de la familia del contenido en el fichero excel para la recatalogacion masiva de contenidos
      */
     public static final int COLUMN_RECATALOG_CONTENT_FAMILY = 7;
     /**
     * N de la columna del tipo de contenido en el fichero excel para la recatalogacion masiva de contenidos
      */
     public static final int COLUMN_RECATALOG_CONTENT_TYPE = 8;
     
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
	/**
     * Extrae el valor de una columna de un archivo excel
     * @param inputPath Ruta del fichero excel
     * @param cellNumber Nmero de la columna a leer
     * @return Lista con los valores de esa columna
     * @throws IOException Se lanza en caso de problema al leer el excel
     */
	public static List extractColumnValueFromExcel(String inputPath, int cellNumber) throws IOException {
		List cellValueList = new ArrayList();
		
		//Creamos el workbook del fichero
		POIFSFileSystem inputFile = new POIFSFileSystem(
						new FileInputStream(inputPath));		
		HSSFWorkbook workBook = new HSSFWorkbook(inputFile);
	
		//Recorremos las pginas
		for (int i=0; i<workBook.getNumberOfSheets(); i++ ) {
		    HSSFSheet sheet = workBook.getSheetAt(i); 	
		    //Recorremos las filas
    		for (Iterator rowIter = sheet.rowIterator(); rowIter.hasNext(); ) {
    		    HSSFRow row =(HSSFRow) rowIter.next();
    			//Obtenemos las celda
    		    HSSFCell cell = row.getCell((short)cellNumber);						
    		    if(cell!=null && !StringUtils.isEmptyString(cell.getStringCellValue())) {
        		    //guardamos su valor
        		    cellValueList.add(cell.getStringCellValue());	
    		    }
    		}			
		}	
		return cellValueList;
	}
	
    /**
     * Extrae el valor de una columna de un archivo excel en una fila exacta y en una hoja exacta
     * @param inputPath Ruta del fichero excel
     * @param cellNumber Nmero de la columna a leer
     * @param rowNumber Nmero de la fila a leer
     * @param SheetNumber Nmero de la hoja a leer
     * @return String con el valor de esa columna
     * @throws IOException Se lanza en caso de problema al leer el excel
     */
    public static String extractColumnValueFromExcel(String inputPath, int cellNumber, int rowNumber, int SheetNumber) throws IOException {
               
        //Creamos el workbook del fichero
        POIFSFileSystem inputFile = new POIFSFileSystem(
                        new FileInputStream(inputPath));        
        HSSFWorkbook workBook = new HSSFWorkbook(inputFile);
    
        //Recuperamos la hoja exacta
        HSSFSheet sheet = workBook.getSheetAt(SheetNumber); 
        
        //Recuperamos la fila exacta
        HSSFRow row = sheet.getRow(rowNumber);
        
        if(row!=null ) {
            //Recuperamos la columna exacta
            HSSFCell cell = row.getCell((short)cellNumber);            
            return cell.getStringCellValue();
        }
        
        //No existe valor se devuelve null
        return null;
    }
    
    /**
     * Lee un archivo excel completo
     * @param inputPath Ruta del fichero excel
     * @return Mapa con los valores de las filas del excel
     * @throws IOException Se lanza en caso de problema al leer el excel
     */
    public static List extractValuesFromExcel(String inputPath) throws IOException {
        List rowsList = new ArrayList();
        
        //Creamos el workbook del fichero
        POIFSFileSystem inputFile = new POIFSFileSystem(
                        new FileInputStream(inputPath));        
        HSSFWorkbook workBook = new HSSFWorkbook(inputFile);
    
        //Recorremos las pginas
        for (int i=0; i<workBook.getNumberOfSheets(); i++ ) {
            HSSFSheet sheet = workBook.getSheetAt(i);   
            //Recorremos las filas
            for (Iterator rowIter = sheet.rowIterator(); rowIter.hasNext(); ) {
                HSSFRow row =(HSSFRow) rowIter.next();
                List rowValues = new ArrayList(); 
                //Recorremos la fila
                
                for(int e=0;e<row.getLastCellNum() + 1;e++) {
                
                    //Cogemos la celda
                    HSSFCell cell = row.getCell((short)e);  
                    if(cell!=null && !StringUtils.isEmptyString(cell.getStringCellValue())) {
                        //guardamos su valor
                        rowValues.add(cell.getStringCellValue());
                    }
                }
                rowsList.add(rowValues);                             
            }           
        }   
        return rowsList;
    } 
	
}
