/*
 * Created on 17-may-2006
 *
 * @author co00390i - Israel Garca
 * (c) 2006 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.dozer.DozerBeanMapper;
import org.dozer.MappingException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

import com.ejie.r01f.xmlproperties.XMLProperties;

/**
 * Clase de utilidad para utilizar los ficheros de mapeo de objetos utilizando DOZER
 * Se utiliza el fichero de mapeo definido en el fichero r01d.properties.xml
 *   <mapFiles>
 *       <mapperObjects id="r01d">html/datos/r01mContentMapping.xml</mapperObjects>
 *       <mapperObjects id="r01g">html/datos/r01mPortalMapping.xml</mapperObjects>
 *   </mapFiles>
 */
public class R01MDozerMappingUtils {
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    private static Properties mappingFiles = new Properties();
    private static Map dozerMappers = null;
///////////////////////////////////////////////////////////////////////////////////////////
//  INICIALIZACION
///////////////////////////////////////////////////////////////////////////////////////////
    static {
        NodeIterator dozerMappingFiles = XMLProperties.getPropertyNodeIterator(R01MConstants.API_APPCODE,"mapFiles/mapperObjects");
        Node node=dozerMappingFiles.nextNode();
        if(node != null) {
            int count=0;
            do {
                // si empieza por / eliminarla... cosas de dozer
                String objsMappingFile = node.getFirstChild().getNodeValue();
                if (objsMappingFile.startsWith("/")) objsMappingFile = objsMappingFile.substring(1);
                mappingFiles.put(node.getAttributes().getNamedItem("id").getNodeValue(),objsMappingFile);
                node = dozerMappingFiles.nextNode();
                count++;
            } while(node != null);
            // Crear el mapa contenedor de mapeadores con el tamao adecuado
            dozerMappers = new HashMap(count);
        }
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    R01MDozerMappingUtils() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Transformacin de un objeto en otro.
     * @param appCode cdigo de aplicacin
     * @param sourceObj objeto origen
     * @param destClass clase destino
     * @return el objeto mapeado
     * @throws MappingException si ocurre un error al mapear
     */
    public static Object map(String appCode, Object sourceObj, Class destClass) throws MappingException {
        DozerBeanMapper mapper = null;
        if (mappingFiles.get(appCode) != null) {
            mapper = (DozerBeanMapper)dozerMappers.get(appCode);
            if (mapper == null) {
                mapper = new DozerBeanMapper();
                List currFile = new ArrayList(1);
                currFile.add(mappingFiles.get(appCode));
                mapper.setMappingFiles(currFile);
                dozerMappers.put(appCode,mapper);
            }
        }
        if (mapper == null) throw new MappingException("NO se ha podido cargar el mapper de dozer para " + appCode);
        return mapper.map(sourceObj, destClass);
    }

    /**
     * Transformacin de un objeto en otro.
     * @param appCode cdigo de aplicacin
     * @param sourceObj objeto origen
     * @param destObj objeto destino
     * @return el objeto mapeado
     * @throws MappingException si ocurre un error al mapear
     */
    public static void map(String appCode, Object sourceObj, Object destObj) throws MappingException {
        DozerBeanMapper mapper = null;
        if (mappingFiles.get(appCode) != null) {
            mapper = (DozerBeanMapper)dozerMappers.get(appCode);
            if (mapper == null) {
                mapper = new DozerBeanMapper();
                List currFile = new ArrayList(1);
                currFile.add(mappingFiles.get(appCode));
                mapper.setMappingFiles(currFile);
                dozerMappers.put(appCode,mapper);
            }
        }
        if (mapper == null) throw new MappingException("NO se ha podido cargar el mapper de dozer para " + appCode);
        mapper.map(sourceObj, destObj);
    }

}
