/*
 * Created on 29-jun-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.ejie.r01m.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import r01f.util.types.Strings;

import com.ejie.r01f.log.R01FLog;

/**
 * Utilidades para el tratamiento de fechas
 */
public abstract class R01MDateUtils {
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    public static final String LANGUAGE_CASTELLANO = R01MConstants.LANG_CASTELLANO;
    public static final String LANGUAGE_EUSKERA = R01MConstants.LANG_EUSKERA;
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Transforma una fecha con el formato <b>"yyyy-MM-dd HH:mm:ss.S"</b> a un objeto java.util.Date
     * @param date la fecha en forma de string
     * @return el string como objeto de tipo fecha ({@link java.util.Date}), null si no se puede parsear
     */
    public static java.util.Date parseDate(String date) {
        return parseDate(date, "yyyy-MM-dd HH:mm:ss.S");
    }
    /**
     * Transforma una fecha con el formato especificado a un objeto java.util.Date
     * @param date la fecha en forma de string
     * @param format el formato de la fecha
     * @return el string como objeto de tipo fecha ({@link java.util.Date}), null si no se puede parsear
     */
    public static java.util.Date parseDate(String date,String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        java.util.Date outDate;
        try {
            outDate = df.parse(date);
        } catch (ParseException parseEx) {
            R01FLog.to("r01d.gestorcontenidos").severe("Error al transformar la fecha " + date + ": " + parseEx.getMessage());
            //throw parseEx;
            return null;
        }
        return outDate;
    }
    /**
     * Retorna un objeto Date a partir de un String.
     * El objeto Date slo se construye a partir del da, mes y ao. No se tiene en cuenta la hora, min y segundo
     * @param strDate fecha en formato String
     * @param lang lenguaje en el que est la fecha
     * @return objeto Date
     * @throws IllegalArgumentException si la fecha no tiene el formato esperado
     */
	public static Date str2Date(String strDate, String lang) throws IllegalArgumentException {
		boolean bResult = true;
		if (strDate == null || strDate.trim().equals("")) return null;

		Date date = new Date();
		if((strDate.length() - strDate.lastIndexOf("/") < 4) && (lang.equals(R01MConstants.LANG_CASTELLANO)))
		return null;

		if((strDate.indexOf("/") < 4)&&(lang.equals(R01MConstants.LANG_EUSKERA)))
		return null;

		SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");

		if(lang.equals(R01MConstants.LANG_EUSKERA))df = new SimpleDateFormat("yyyy/MM/dd");

		df.setLenient(false);

		if(_isNotEmpty(strDate)) {
			try {
				date.setTime(df.parse(strDate).getTime());
			} catch(ParseException pcEx) {
				bResult = false;
			}
		} else {
			bResult = false;
		}

		if (!bResult) throw new IllegalArgumentException("Error al transformar la fecha [" + strDate + "] al idioma " + lang);

	 return date;
	}
    /**
     * Retorna una String que contiene la fecha en Euskera o en Castellano
     * @param date
     * @param lang lenguaje en el que devuelve la fecha
     * @return string
     */
	public static String dateToStr(Date date, String lang) {
		if (date == null) return "";
		SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
		if(lang.equals(R01MConstants.LANG_EUSKERA)) df.applyPattern("yyyy/MM/dd");

		return df.format(date);
	}
	/**
     * Retorna un String que contiene la hora en forma de cadena HH:mm
	 * @param date la fecha
	 * @return fecha formateada
	 */
	public static String timeToStr(Date date){
		if (date == null) return "";

		SimpleDateFormat df = new SimpleDateFormat("HH:mm");
		return df.format(date);
	}
	/**
     * Retorna un String que contiene la hora en forma de cadena HH:mm:ss
	 * @param date la fecha
	 * @return fecha formateada
	 */
	public static String timeSecondsToStr(Date date){
		if (date == null) return "";
		SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
		return df.format(date);
	}
	/**
     * Devuelve una cadena con la fecha y hora en el formato yyyy/MM/dd-HH:mm
	 * @param date
	 * @param strHour
	 * @return fecha formateada
	 */
	public static Date strTimeToDate (Date date,String strHour){
		SimpleDateFormat df = null;
		Calendar cal = null;
		StringBuffer sFecha = new StringBuffer();

		cal = Calendar.getInstance();
		cal.setTime(date);

		sFecha.append(_fillZeroLeft(String.valueOf(cal.get(Calendar.YEAR)), 4));
		sFecha.append('/');
		sFecha.append(_fillZeroLeft(String.valueOf(cal.get(Calendar.MONTH) + 1), 2));
		sFecha.append('/');
		sFecha.append(_fillZeroLeft(String.valueOf(cal.get(Calendar.DATE)), 2));
		sFecha.append('-');
		sFecha.append(strHour);

		df = new SimpleDateFormat("yyyy/MM/dd-HH:mm");
		df.setLenient(false);

		try{
			date.setTime(df.parse(sFecha.toString()).getTime());
		}catch (Exception e) {
			return null;
		}

		return date;
	}
	/**
	 * @param date
	 * @param userLanguage
	 * @return fecha formateada
	 */
	public static String dateTimeToStr(Date date, String userLanguage){
		return dateToStr(date, userLanguage) + " " + timeToStr(date);
	}
	/**
	 * @param date
	 * @param userLanguage
	 * @return fecha formateada
	 */
	public static String dateTimeSecondsToStr(Date date, String userLanguage){
		return dateToStr(date, userLanguage) + " " + timeSecondsToStr(date);
	}
    /**
     * Retorna la fecha actual
     * @return fecha actual
     */
    public static Date today(){
        return Calendar.getInstance().getTime();
    }
    /**
     * Obtiene el ao actual
     * @return el ao
     */
    public static String getTodayYear() {
        return "" + Calendar.getInstance().get(Calendar.YEAR);
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS PRIVADOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Comprueba si una cadena es null o vacia ("")
     * @param str la cadena a comprobar
     * @return true si la cadena es null o ""
     */
    private static boolean _isNotEmpty(String str) {
		return str != null && str.length() > 0;
	}
	/**
     * Rellena una cadena con ceros a la izquierda hasta una determinada longitud
	 * @param cadena cadena de entrada
	 * @param length nmeros de ceros a incluir
	 * @return la nueva cadena
	 */
	private static StringBuffer _fillZeroLeft(String cadena, int length) {
	    StringBuffer cadenaChanged = new StringBuffer(cadena);
		if (!Strings.isNullOrEmpty(cadena)) {
    		while (cadenaChanged.length() < length) {
    		    cadenaChanged.insert(0,'0');
    		}
		}
		return cadenaChanged;
	}



}
