/*
 * Created on 12-may-2006
 * 
 * @author co01556e - Alex Lara
 * (c) 2006 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Constantes para la configuracion del referenciador
 * OJO !!!!!
 * Si se introduce algun tipo nuevo, hay que modificar todos los metodos de explotacion de los tipos
 */
public abstract class R01MConstantsUrlReferenceConfig implements Serializable{    
    private static final long serialVersionUID = -5749482461303672649L;
    
    
    /**
     * Tipo desconocido, se utiliza para la inicializacion de la configuracion del formulario del referneciador
     */
    public static final int TYPE_UNKNOW = -1; 
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LA URL EXTERNA
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_EXTERNAL_URL = 0;
    
    private static final Map getDescription_url () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Enlace externo");
        descriptionMap.put("eu","eu-Enlace externo");
        return descriptionMap;
    }
    
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LA PAGINA
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_PAGE = 1;
    
    private static final Map getDescription_page () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","P&aacute;gina");
        descriptionMap.put("eu","Orri");
        return descriptionMap;
    }
    
    /**
     * Areas visuales por las que filtrar las bsquedas de pginas
     */
    public static final String VA_CONTENT = "content";
    public static final String VA_SEARCH_ENGINE = "searchEngine";
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA EL CONTENIDO
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_CONTENT = 2;
    
    private static final Map getDescription_content () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Contenido");
        descriptionMap.put("eu","Edukia");
        return descriptionMap;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LA BUSQUEDA
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_SEARCH = 3;
    
    private static final Map getDescription_search () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","B&uacute;squeda");
        descriptionMap.put("eu","Bilaketa");
        return descriptionMap;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LA BUSQUEDA MAS LISTA DE CONTENIDOS
///////////////////////////////////////////////////////////////////////////////////////////  
    public static final int TYPE_SEARCH_CONTENTLIST = 4;
    
    private static final Map getDescription_search_contentList() {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","B&uacute;squeda y lista de contenidos");
        descriptionMap.put("eu","Bilaketa eta eduki zerrenda");
        return descriptionMap;
    }
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA EL BOLETIN
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_NEWSLETTER = 5;
    
    private static final Map getDescription_newsletter () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Bolet&iacute;n");
        descriptionMap.put("eu","Buletina");
        return descriptionMap;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA EL LISTA DE CONTENIDOS
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_CONTENT_LIST = 6;
    
    private static final Map getDescription_contentList () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Lista de Contenidos");
        descriptionMap.put("eu","Eduki Zerrenda");
        return descriptionMap;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LOS ARCHIVOS ADJUNTOS
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_ATTACHED_DATAFILE = 7;
    
    private static final Map getDescription_attachedDataFile () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Archivos Adjuntos");
        descriptionMap.put("eu","Erantsitako Artxiboa");
        return descriptionMap;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LA OPCION "SIN URL"
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_WITHOUT_URL = 8;
    
    private static final Map getDescription_withoutUrl() {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Sin enlace");
        descriptionMap.put("eu","Sin enlace-eu");
        return descriptionMap;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  METODOS PUBLICOS
///////////////////////////////////////////////////////////////////////////////////////////    
    
    /**
     * Obtener la descripcion idiomatica segun tipo de contenido
     * @param type tipo de url 
     * @return mapa con las descripciones de la url indexadas por idioma
     */
    public static Map getTypeDescription (int type) {
        Map description = null;
        if(type == R01MConstantsUrlReferenceConfig.TYPE_EXTERNAL_URL) {
            description = R01MConstantsUrlReferenceConfig.getDescription_url();
        } else if(type == R01MConstantsUrlReferenceConfig.TYPE_CONTENT){
            description = R01MConstantsUrlReferenceConfig.getDescription_content();
        } else if(type == R01MConstantsUrlReferenceConfig.TYPE_CONTENT_LIST){
            description = R01MConstantsUrlReferenceConfig.getDescription_contentList();
        } else if(type == R01MConstantsUrlReferenceConfig.TYPE_NEWSLETTER){
            description = R01MConstantsUrlReferenceConfig.getDescription_newsletter();
        } else if(type == R01MConstantsUrlReferenceConfig.TYPE_PAGE){
            description = R01MConstantsUrlReferenceConfig.getDescription_page();
        } else if(type == R01MConstantsUrlReferenceConfig.TYPE_SEARCH){
            description = R01MConstantsUrlReferenceConfig.getDescription_search();
        } else if(type == R01MConstantsUrlReferenceConfig.TYPE_SEARCH_CONTENTLIST) {
            description = R01MConstantsUrlReferenceConfig.getDescription_search_contentList();
        } else if(type == R01MConstantsUrlReferenceConfig.TYPE_ATTACHED_DATAFILE) {
            description = R01MConstantsUrlReferenceConfig.getDescription_attachedDataFile();            
        } else if(type == R01MConstantsUrlReferenceConfig.TYPE_UNKNOW) {
            Map newDescription = new HashMap();
            newDescription.put("es","Tipo desconocido");
            newDescription.put("eu","eu_Tipo desconocido");
            description = newDescription;
        } else if(type == R01MConstantsUrlReferenceConfig.TYPE_WITHOUT_URL) {
                description = R01MConstantsUrlReferenceConfig.getDescription_withoutUrl();    
        }else {
            Map newDescription = new HashMap();
            newDescription.put("es","Introducir su descripcion en R01MConstanstUrlReferenceConfig");
            newDescription.put("eu","Introducir su descripcion en R01MConstanstUrlReferenceConfig");
            description = newDescription;
        }
        
        return description;
    }
    
    /**
     * Metodo que valida si el tipo es correcto.
     * IMPORTANTE !!!: actualizar el margen si se mete un tipo nuevo
     * @param type tipo de url
     * @return true si el tipo se encuentra entre los tipos permitidos
     */
    public static boolean isValidType(int type) {
        
        if(0<= type && type <=8) {
            return true;
        }
        return false;
    }

/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LAS URL YA GENERADAS Y GUARDADAS EN EL GESTOR DE CONTENIDOS
///////////////////////////////////////////////////////////////////////////////////////////
    private static final String STR_TYPE_EXTERNAL_URL = "url"; 
    private static final String STR_TYPE_CONTENT = "content";
    private static final String STR_TYPE_CONTENT_LIST = "contentList";
    private static final String STR_TYPE_NEWSLETTER = "newsLetter";
    private static final String STR_TYPE_PAGE = "page";
    private static final String STR_TYPE_SEARCH_CONTENTLIST = "search_contentList";
    private static final String STR_TYPE_SEARCH = "search";
    private static final String STR_TYPE_WITHOUT_URL = "";
    
    /**
     * Metodo que transforma el tipo que se usaba string por el tipo int que se usa actualmente
     * @param type (String) tipo de url
     * @return int tipo de url actual
     */
    public static int transformType(String type) {
        int newType = TYPE_EXTERNAL_URL;
        if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_EXTERNAL_URL)) {
            newType = TYPE_EXTERNAL_URL;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_SEARCH)) {
            newType = TYPE_SEARCH;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_WITHOUT_URL)) {
            newType = TYPE_WITHOUT_URL;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_PAGE)) {
            newType = TYPE_PAGE;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_CONTENT)) {
            newType = TYPE_CONTENT;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_CONTENT_LIST)){
            newType = TYPE_SEARCH_CONTENTLIST;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_NEWSLETTER)){
            newType = TYPE_NEWSLETTER;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_SEARCH_CONTENTLIST)){
            newType = TYPE_CONTENT_LIST;
        }
        
        return newType;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LAS URL ANTIGUAS
///////////////////////////////////////////////////////////////////////////////////////////    

    /**
     * Url externa
     */
    private static final String MIGRATIONTYPE_EXTERNAL_URL = "url";
    /**
     * Busqueda
     */
    private static final String MIGRATIONTYPE_SEARCH = "search";
    /**
     * texto sin url
     */
    private static final String MIGRATIONTYPE_WITHOUT_URL = "";
    /**
     * Pagina de presentacion
     */
    private static final String MIGRATIONTYPE_PAGE = "page";
    /**
     * Contenido
     */
    private static final String MIGRATIONTYPE_CONTENT = "content";
    /**
     * Busqueda + lista de contenidos
     */
    private static final String MIGRATIONTYPE_SLIST = "slist";
    /**
     * boletin
     */
    private static final String MIGRATIONTYPE_NEWSLETTER = "newsletter";
    /**
     * Gazteaukera
     */
    private static final String MIGRATIONTYPE_GAZTEAUKERA = "k21";
    /**
     * Contenido + pagina de presentacion
     */
    private static final String MIGRATIONTYPE_BOTH = "both";
    /**
     * busqueda + pagina de presentacion
     */
    private static final String MIGRATIONTYPE_SPG = "spg";
    /**
     * busqueda + lista de contenidos + pagina de presentacion
     */
    //private static final String MIGRATIONTYPE_LSPG = "lspg";
    
    /**
     * Metodo que transforma los tipos de url antiguas a las nuevas
     * @param type tipo de url antigua
     * @return int tipo de url nueva
     */
    public static int transformTypeForPortalsMigration (String type) throws Exception{
        int newType = TYPE_EXTERNAL_URL;
        if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_EXTERNAL_URL)) {
            newType = TYPE_EXTERNAL_URL;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_SEARCH)) {
            newType = TYPE_SEARCH;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_WITHOUT_URL)) {
            newType = TYPE_WITHOUT_URL;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_PAGE)) {
            newType = TYPE_PAGE;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_CONTENT)) {
            newType = TYPE_CONTENT;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_BOTH)) {
            newType = TYPE_CONTENT;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_SPG)){
            newType = TYPE_SEARCH;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_SPG)){
            newType = TYPE_SEARCH_CONTENTLIST;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_SLIST)){
            newType = TYPE_SEARCH_CONTENTLIST;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_NEWSLETTER)){
            newType = TYPE_NEWSLETTER;
        }else if(type.toLowerCase().equalsIgnoreCase(MIGRATIONTYPE_GAZTEAUKERA)){
            newType = TYPE_WITHOUT_URL;
        }else {
            throw new Exception("Error transformando el tipo de url: "+type);
        }
        
        return newType;
    }

    
   
    
    
    
    public static  String DEFAULT_LINK_NEW_WINDOW = "false";   
    /***************************************************/
    //CLAVES PARA MAPA DE DETALLES RESULTADOS DEL REFERENCIADOR
    /*****************************************************/
    //claves para le boletin
    public static String NEWSLETTER_PUBLISHYEAR="newsLetterPublishYear";
    public static String NEWSLETTER_PUBLISHMONTH="newsLetterPublishMonth";
    public static String NEWSLETTER_NUMBERCODE="newsLetterNumberCode";
    public static String NEWSLETTER_LANG="newsLetterLang";
    //claves para la busqueda
    public static String SEARCH_GUID="searchGUID";
    public static String QUERY_XML = "queryXml";
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Constructor vacio
     */
    public R01MConstantsUrlReferenceConfig() {
        super();
    }
}
