/*
 * Created on 16/03/2011
 * 
 * @author JGONZACR - Jorge Gonzalez
 * (c) 2011 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
* Constantes para la configuracion del referenciador
* OJO !!!!!
* Si se introduce algun tipo nuevo, hay que modificar todos los metodos de explotacion de los tipos
*/
public abstract class R01MConstantsReferencerConfig implements Serializable{
    private static final long serialVersionUID = -3655448246205298824L;

    /**
     * Tipo desconocido, se utiliza para la inicializacion de la configuracion del formulario del referneciador
     */
    public static final int TYPE_UNKNOW = -1; 
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LA PAGINA
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_PAGE = 1;
    
    private static final Map getDescription_page () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","P&aacute;gina");
        descriptionMap.put("eu","Orri");
        return descriptionMap;        
    }
    
    public static final String PAGE_LANG_PATTERN="(/*.)(es)(/)";
    /**
     * Areas visuales por las que filtrar las bsquedas de pginas
     */
    public static final String VA_CONTENT = "content";
    public static final String VA_SEARCH_ENGINE = "searchEngine";
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA EL CONTENIDO
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_CONTENT = 2;
    
    private static final Map getDescription_content () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Contenido");
        descriptionMap.put("eu","Edukia");
        return descriptionMap;
    }
    
    public static final String CONTENT_LANG_PATTERN="(/contenidos/[^/]+/[^/]+/)([^/_]+)(_[^/]+/.*)";
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LA BUSQUEDA
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_SEARCH = 3;
    
    private static final Map getDescription_search () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","B&uacute;squeda");
        descriptionMap.put("eu","Bilaketa");
        return descriptionMap;
    }
    public static final String SEARCH_LANG_PATTERN= "(/.*documentLanguage\\.EQ\\.)([^.;&,]+)(.*)";
    
    public static final String URL_ALIAS_PATTERN="(/.*/)[^/]+(.html)";
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA EL LISTA DE CONTENIDOS
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_CONTENT_LIST = 4;
    
    private static final Map getDescription_contentList () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Lista de Contenidos");
        descriptionMap.put("eu","Eduki Zerrenda");
        return descriptionMap;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA EL BOLETIN
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_NEWSLETTER = 5;
    
    private static final Map getDescription_newsletter () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Bolet&iacute;n");
        descriptionMap.put("eu","Buletina");
        return descriptionMap;
    }
    
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LOS ARCHIVOS ADJUNTOS
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_ATTACHED_DATAFILE = 6;
    
    private static final Map getDescription_attachedDataFile () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Archivos Adjuntos");
        descriptionMap.put("eu","Erantsitako Artxiboa");
        return descriptionMap;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LA OPCION "SIN URL"
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_WITHOUT_URL = 7;
    
    private static final Map getDescription_withoutUrl() {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Sin enlace");
        descriptionMap.put("eu","Sin enlace-eu");
        return descriptionMap;
    }
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LA URL EXTERNA
///////////////////////////////////////////////////////////////////////////////////////////    
    public static final int TYPE_EXTERNAL_URL = 8;
    
    private static final Map getDescription_url () {
        Map descriptionMap = new HashMap();
        descriptionMap.put("es","Enlace externo");
        descriptionMap.put("eu","eu-Enlace externo");
        return descriptionMap;
    }
 
    
/////////////////////////////////////////////////////////////////////////////////////////////
//  METODOS PUBLICOS
///////////////////////////////////////////////////////////////////////////////////////////    
    
    /**
     * Obtener la descripcion idiomatica segun tipo de contenido
     * @param type tipo de url 
     * @return mapa con las descripciones de la url indexadas por idioma
     */
    public static Map getTypeDescription (int type) {
        Map description = null;
        if(type == R01MConstantsReferencerConfig.TYPE_EXTERNAL_URL) {
            description = R01MConstantsReferencerConfig.getDescription_url();
        }else if(type == R01MConstantsReferencerConfig.TYPE_CONTENT){
            description = R01MConstantsReferencerConfig.getDescription_content();
        }else if(type == R01MConstantsReferencerConfig.TYPE_CONTENT_LIST){
            description = R01MConstantsReferencerConfig.getDescription_contentList();
        }else if(type == R01MConstantsReferencerConfig.TYPE_NEWSLETTER){
            description = R01MConstantsReferencerConfig.getDescription_newsletter();
        }else if(type == R01MConstantsReferencerConfig.TYPE_PAGE){
            description = R01MConstantsReferencerConfig.getDescription_page();
        }else if(type == R01MConstantsReferencerConfig.TYPE_SEARCH){
            description = R01MConstantsReferencerConfig.getDescription_search();
        }else if(type == R01MConstantsReferencerConfig.TYPE_ATTACHED_DATAFILE) {
            description = R01MConstantsReferencerConfig.getDescription_attachedDataFile();            
        }else if(type == R01MConstantsReferencerConfig.TYPE_WITHOUT_URL) {
            description = R01MConstantsReferencerConfig.getDescription_withoutUrl();
        }else {
            Map newDescription = new HashMap();
            newDescription.put("es","Introducir su descripcion en R01MConstanstUrlReferenceConfig");
            newDescription.put("eu","Introducir su descripcion en R01MConstanstUrlReferenceConfig");
            description = newDescription;
        }
        
        return description;
    }
    
    /**
     * Metodo que valida si el tipo es correcto.
     * IMPORTANTE !!!: actualizar el margen si se mete un tipo nuevo
     * @param type tipo de url
     * @return true si el tipo se encuentra entre los tipos permitidos
     */
    public static boolean isValidType(int type) {
        
        if(0<= type && type <=8) {
            return true;
        }
        return false;
    }
    

/////////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA LAS URL YA GENERADAS Y GUARDADAS EN EL GESTOR DE CONTENIDOS
///////////////////////////////////////////////////////////////////////////////////////////
    private static final String STR_TYPE_EXTERNAL_URL = "url"; 
    private static final String STR_TYPE_CONTENT = "content";
    private static final String STR_TYPE_CONTENT_LIST = "contentList";
    private static final String STR_TYPE_NEWSLETTER = "newsLetter";
    private static final String STR_TYPE_PAGE = "page";
    private static final String STR_TYPE_SEARCH_CONTENTLIST = "search_contentList";
    private static final String STR_TYPE_SEARCH = "search";
    private static final String STR_TYPE_WITHOUT_URL = "";
    
    /**
     * Metodo que transforma el tipo que se usaba string por el tipo int que se usa actualmente
     * @param type (String) tipo de url
     * @return int tipo de url actual
     */
    public static int transformType(String type) {
        int newType = TYPE_EXTERNAL_URL;
        if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_EXTERNAL_URL)) {
            newType = TYPE_EXTERNAL_URL;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_SEARCH)) {
            newType = TYPE_SEARCH;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_WITHOUT_URL)) {
            newType = TYPE_WITHOUT_URL;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_PAGE)) {
            newType = TYPE_PAGE;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_CONTENT)) {
            newType = TYPE_CONTENT;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_NEWSLETTER)){
            newType = TYPE_NEWSLETTER;
        }else if(type.toLowerCase().equalsIgnoreCase(STR_TYPE_SEARCH_CONTENTLIST)){
            newType = TYPE_CONTENT_LIST;
        }
        
        return newType;
    }
    

///////////////////////////////////////////////////////////////////////////////////////////
// CONSTANTES QUE UTILIZAMOS COMO CLAVES EN LOS MAPAS DATA DE LOS OBEJETOS
///////////////////////////////////////////////////////////////////////////////////////////    
    ///// /////////////////////////////////////////////////////////////////////////////////////////
    // CONSTANTES USADAS EN EL MAPA DATA DEL OBJETO {@link R01MLinkComposer}
    ///////////////////////////////////////////////////////////////////////////////////////////    

    /**
     * Clave para almacenar la query
     */
    public static final String QUERY = "query";
    
    /**
     * Clave para almacenar la query
     */
    public static final String QUERY_XML= "queryXml";
    
    
    /**
     * Clave para almacenar la query
     */
    public static final String QUERY_DESCRIPTION = "queryDescription";
    
    /**
     * Clave para almacenar la descripcion de lo seleccionado
     */
    public static final String LINK_DESCRIPTION = "linkDescription";  
    
    /**
     * Clave para almacenar el idioma
     */
    public static final String LINK_LANG = "lang";
    
    ///// /////////////////////////////////////////////////////////////////////////////////////////
    // CONSTANTES USADAS EN EL MAPA DATA DEL OBJETO {@link R01MLink}
    ///////////////////////////////////////////////////////////////////////////////////////////    
    
    /**
     * Clave para almacenar el oid del contenido
     */
    public static final String CONTENT_OID = "contentOid";
    
    /**
     * Clave para almacenar el nombre del contenido
     */
    public static final String CONTENT_NAME = "contentName";
    
    /**
     * Clave para almacenar el oid del documento
     */
    public static final String DOCUMENT_OID = "documentOid";
    
    /**
     * Clave para almacenar el nombre del documento
     */
    public static final String DOCUMENT_NAME = "documentName";
    
    /**
     * Clave para almacenar el oid de la pgina
     */
    public static final String PAGE_OID = "pageOid";
    
    /**
     * Clave para almacenar el nombre de la pgina
     */
    public static final String PAGE_NAME = "pageName";
    
    /**
     * Clave para almacenar la url
     */
    public static final String URL = "url";
    
    /**
     * Clave para almacenar la url amigable
     */
    public static final String URL_FRIENDLY = "urlFriendly";
    
    /**
     * Clave para almacenar la url amigable de la pgina
     */
    public static final String PAGE_URL_FRIENDLY = "pageUrlFriendly";
    
    
    /**
     * Clave para almacenar el nombre del fichero adjunto
     */
    public static final String ATTACHMENT_NAME = "attachmentName";
    
    /**
     * Clave para almacenar el nombre del fichero adjunto
     */
    public static final String ATTACHMENT_SIZE = "attachmentSize";
    
    /**
     * Clave para el html formateado del recurso.
     */
    public static final String RESOURCE_HTML = "resourceHTML";
    
    /**
     * Clave para el repositorio de publicacion
     */
    public static final String PUBLISH_REPOSITORY = "documentPublishRepository";
    /**
     * Clave para el repositorio de publicacion
     */
    public static final String CONTENT_TYPOLOGY = "contentTypology";
    
    /**
     * Lenguaje del boletin
     */
    public static final String NEWSLETTER_LANG = "newsLetterLang";
    /***************************************************/
    //CLAVES PARA MAPA DE DETALLES RESULTADOS DEL REFERENCIADOR
    /*****************************************************/
    //claves para le boletin
    public static int NEWSLETTER_PUBLISHYEAR_KEY=3;
    public static int NEWSLETTER_PUBLISHMONTH_KEY=4;
    public static int NEWSLETTER_NUMBERCODE_KEY=5;
    public static int NEWSLETTER_LANG_KEY=6;  
    
    /**
     * Sufijo que se aade al nmero de boletn, para el idioma castellano
     * (Boletines a partir de Julio 2011)
     */
    public static final String NEWSLETTER_LANG_ES_KEY = "a";
    /**
     * Sufijo que se aade al nmero de boletn, para el idioma euskera
     * (Boletines a partir de Julio 2011)
     */
    public static final String NEWSLETTER_LANG_EU_KEY = "e";
    
    
    
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Constructor vacio
     */
    public R01MConstantsReferencerConfig() {
        super();
    }
}