/*
 * Created on Sep 5, 2005
 *
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;

/**
 * Constantes para R01M
 */
public class R01MConstants {
///////////////////////////////////////////////////////////////////////////////////////////
//  Separadores para uso como caracteres ASCII de control / no imprimibles.
///////////////////////////////////////////////////////////////////////////////////////////    
	/**
     * Separadores para uso como caracteres ASCII de control / no imprimibles.
     */
    public static final char UNIT_SEPARATOR = '\u001F';
    public static final char RECORD_SEPARATOR = '\u001E';
    public static final char GROUP_SEPARATOR = '\u001D';
    public static final char FILE_SEPARATOR = '\u001C';
///////////////////////////////////////////////////////////////////////////////////////////
//  Entornos y Aplicaciones
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Entorno (desarrollo, pruebas, produccin ...)
     */
    public static final String ENVIRONMENT = XMLProperties.get("r01m","environment/code","p") ;
    /**
     * Cdigo de la aplicacin Gestor de contenidos.
     */
    public static final String CONTENTMANAGER_APPCODE = XMLProperties.get("r01m","applicationCodes/contentManager","r01d");
    /**
     * Cdigo de la aplicacin Gestor de ejes.
     */
    public static final String STRUCTURES_APPCODE = XMLProperties.get("r01m","applicationCodes/structures","r01e");
    /**
     * Cdigo de la aplicacin Framework.
     */
    public static final String FRAMEWORK_APPCODE = XMLProperties.get("r01m","applicationCodes/framework","r01f");
    /**
     * Cdigo de la aplicacin Gestor de portales.
     */
    public static final String PORTALMANAGER_APPCODE = XMLProperties.get("r01m","applicationCodes/portalAdmin","r01g");
    /**
     * Cdigo de la aplicacin Visualizacin de portales.
     */
    public static final String PORTALRENDER_APPCODE = XMLProperties.get("r01m","applicationCodes/portalRender","r01h");
    /**
     * Cdigo de la aplicacin Integracin entre Lotes.
     */
    public static final String INTEGRATION_APPCODE = XMLProperties.get("r01m","applicationCodes/integration","r01i");
    /**
     * Cdigo de la aplicacin Publicador.
     */
    public static final String PUBLISHER_APPCODE = XMLProperties.get("r01m","applicationCodes/publisher","r01j");
    /**
     * Cdigo de la aplicacin Buscador.
     */
    public static final String SEARCHENGINE_APPCODE = XMLProperties.get("r01m","applicationCodes/searchEngine","r01k");
    /**
     * Cdigo de la aplicacin Interfaces auxiliares.
     */
    public static final String USERINTERFACE_APPCODE = XMLProperties.get("r01m","applicationCodes/userInterface","r01l");
    /**
     * Cdigo de la aplicacin API Presencia en Internet.
     */
    public static final String API_APPCODE = XMLProperties.get("r01m","applicationCodes/api","r01m");
    /**
     * Cdigo de la aplicacin API Presencia en Internet.
     */
    public static final String INTERNALAPI_APPCODE = XMLProperties.get("r01m","applicationCodes/internalapi","r01p");
    /**
     * Cdigo de la aplicacin Administracin Lote3.
     */
    public static final String SYSTEMADMINISTRATION_APPCODE = XMLProperties.get("r01m","applicationCodes/systemAdministration","r01n");
    /**
     * Dominio para el cliente.
     */
    public static final String CUSTOMER_DOMAIN = XMLProperties.get("r01m","customerInfo/domain","euskadi.net");
    /**
     * Nombre para el cliente.
     */
    public static final String CUSTOMER_NAME = XMLProperties.get("r01m","customerInfo/name","euskadi.net");
    /** 
     * Instacia que esta atendiendo 
     */
    public static final String CLUSTER = XMLProperties.getProperty(R01MConstants.API_APPCODE,"weblogicCluster/name","apps");
    
///////////////////////////////////////////////////////////////////////////////////////////
//  Urls de las pginas de inicio de las aplicaciones
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Pgina de inicio para extranet.
     */
    public static final String URL_EXTRANET = XMLProperties.get("r01m","uri/extranet","www.contenidos.servicios.jakinaplus.ejgvdns");
    /**
     * Pgina de inicio para internet.
     */
    public static final String URL_INTERNET = XMLProperties.get("r01m","uri/internet","www.euskadi.net");
    /**
     * Alias para uri de contenidos
     */
    public static final String CONTENT_ALIAS = XMLProperties.get("r01m","uri/contentAlias","/contenidos");
    /**
     * Pgina de inicio para el Gestor de Contenidos.
     */
    public static final String CONTENTMANAGER_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/contentManager", "/r01lMainWar/r01lMenuPrincipal.jsp?lang=");
    /**
     * Pgina de inicio para el Gestor de Ejes.
     */
    public static final String STRUCTURES_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/structures", "/r01lMainWar/r01lMenuPrincipal.jsp?lang=");
    /**
     * Pgina de inicio para el Framework.
     */
    public static final String FRAMEWORK_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/framework", "/r01lMainWar/r01lMenuPrincipal.jsp?lang="); //No se usa
    /**
     * Pgina de inicio para el Gestor de Portales.
     */
    public static final String PORTALADMIN_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/portalAdmin", "/r01lMainWar/r01lMenuPrincipal.jsp?lang=");
    /**
     * Pgina de inicio para el Renderizado de Portales.
     */
    public static final String PORTALRENDER_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/portalRender", "/r01lMainWar/r01lMenuPrincipal.jsp?lang=");
    /**
     * Pgina de inicio para la Integracin interlotes.
     */
    public static final String INTEGRATION_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/integration", "/r01lMainWar/r01lMenuPrincipal.jsp?lang=");
    /**
     * Pgina de inicio para el Publicador.
     */
    public static final String PUBLISHER_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/publisher", "/r01lMainWar/r01lMenuPrincipal.jsp?lang=");
    /**
     * Pgina de inicio para el Buscador.
     */
    public static final String SEARCHENGINE_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/searchEngine", "/r01lMainWar/r01lMenuPrincipal.jsp?lang=");
    /**
     * Pgina de inicio para las interfaces de presentacin.
     */
    public static final String USERINTERFACE_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/userInterface", "/r01lMainWar/r01lMenuPrincipal.jsp?lang=");
    /**
     * Pgina de inicio para el API.
     */
    public static final String API_INIT_PAGE_APP = XMLProperties.get("r01m","initPageApplicationUrls/api", "/r01lMainWar/r01lMenuPrincipal.jsp?lang=");
    /**
     * Identificador del cluster para los portales
     */
    public static final String PORTAL_CLUSTER_ID =  XMLProperties.get("r01m","typologyOids/euskadi", "euskadi");
    /**
     * Identificador de la familia de portal
     */
    public static final String PORTAL_FAMILY_ID =  XMLProperties.get("r01m","typologyOids/portalFamily", "portal");
    /**
     * Identificador del tipo para portales
     */
    public static final String PORTAL_TYPE_ID =  XMLProperties.get("r01m","typologyOids/portalType", "portal_page");
    /**
     * Path base a la zona donde se almacenan los portales en el entorno local
     */
    public static final String PORTAL_DATA_BASE_PATH =  XMLProperties.get("r01m","localPaths/basePaths/portalBasePath", "D:/tools/workspaces/r01/r01mTestData/iwmnt/euskadiplus/main/r01_euskadi_portal_loc/WORKAREA/");
    /**
     * Path base a la zona donde se almacenan los contenidos en el entorno local
     */
    public static final String CONTENT_DATA_BASE_PATH =  XMLProperties.get("r01m","localPaths/basePaths/contentBasePath", "D:/tools/workspaces/r01/r01mTestData/iwmnt/euskadiplus/main/r01_euskadi_cont_loc/WORKAREA/");

///////////////////////////////////////////////////////////////////////////////////////////
//  Informacin de soporte
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Servidor de correo SMTP.
     */
    public static final String URL_DNS_SMTP = XMLProperties.get("r01m","mailsupport/hostsmtp");
    /**
     * Buzn de correo de soporte.
     */
    public static final String MAIL_ADDRESS_SGW = XMLProperties.get("r01m","mailsupport/gestwebaddress");
    /**
     * Buzn de correo del CAU.
     */
    public static final String MAIL_ADDRESS_CAU = XMLProperties.get("r01m","mailsupport/cauaddress");
    /**
     * Buzn de correo de asistencia.
     */
    public static final String MAIL_ADDRESS_ASSIS = XMLProperties.get("r01m","mailsupport/assistaddress");
    /**
     * Buzn de correo del emisor.
     */
    public static final String MAIL_ADDRESS_FROM = XMLProperties.get("r01m","mailsupport/fromaddress");

///////////////////////////////////////////////////////////////////////////////////////////
//  Ficheros de mapeo
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Fichero de mapeo para objetos del buscador.
     */
    public static final String QUERY_RESULTS_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/queryAndResults");
    /**
     * Fichero de mapeo para objetos del gestor de contenidos (Dozer).
     */
    public static final String CONTENTMODEL_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/contentModel");
    /**
     * Fichero de mapeo para objetos del gestor de ejes (Dozer).
     */
    public static final String STRUCTURESMODEL_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/catalogModel");
    /**
     * Fichero de mapeo para objetos de configuracin del gestor de contenidos.
     */
    public static final String CONFIGCONTENTMODEL_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/configContentModel");
    /**
     * Fichero de mapeo para objetos indexables.
     */
    public static final String INDEXABLEOBJECTS_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/indexableObjects");
    /**
     * Fichero de mapeo para objetos del publicador.
     */
    public static final String PUBLISHEROBJECTS_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/publisherObjects");
    /**
     * Fichero de mapeo para objetos del referenciador.
     */
    public static final String URLREFERENCER_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/xmlUrlReferencerMapping");
    /**
     * Fichero de mapeo para objetos Resource y nuevo referenciador
     */
    public static final String LINK_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/linkMapping");
    /**
     * Fichero de mapeo para objetos del publicador (Dozer).
     */
    public static final String PUBLISHERMODEL_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/publisherModel");
    /**
     * Fichero de mapeo para objetos del gestor de portales (Dozer).
     */
    public static final String PORTALMODEL_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/portalModel");
    /**
     * Fichero de mapeo para alias de portales (Dozer).
     */
    public static final String PORTALALIAS_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/portalAlias");
    /**
     * Fichero de mapeo para objetos del buscador e indexador (Dozer).
     */
    public static final String INDEXMODEL_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/indexableModel");
    /**
     * Fichero de mapeo para objetos de configuracin del gestor de portales.
     */
    public static final String CONFIGPORTALMODEL_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/configPortalModel");
    /**
     * Fichero de mapeo para objetos de contenidos buscables.
     */
    public static final String CONTENTSEARCHFORMDEF_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/contentSearchFormDef");
    /**
     * Fichero de mapeo para objetos del referenciador.
     */
    public static final String HTMLTOURLREFERENCER_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/htmlToUrlReferencer");
    /**
     * Fichero de mapeo para objetos de aplicaciones del proxy.
     */
    public static final String SSIPROXYCONFIG_MAPFILE = XMLProperties.get(R01MConstants.API_APPCODE,"xoMappingFiles/ssiProxyConfig");

///////////////////////////////////////////////////////////////////////////////////////////
//  Lenguajes
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Buffer de idiomas permitidos para el Gestor de Contenidos (para r01d).
     */
    public static final List DOCUMENT_ALLOWED_LANGS = XMLProperties.getPropertyList(R01MConstants.API_APPCODE,"defaultLanguages/lang",Arrays.asList(new String[] {"eu","es","en","fr","de","cz","cn","da","fi","el","hu","it","jp","nl","no","pl","pt","sv"}));

    /**
     * Lenguaje por defecto de todas las aplicaciones.
     */
    public static final String DEFAULT_LANG = XMLProperties.get(R01MConstants.API_APPCODE,"defaultLang","es");
    /**
     * Cdigo del idioma en castellano.
     */
    public static final String LANG_CASTELLANO = "es";
    /**
     * Cdigo del idioma en euskera.
     */
    public static final String LANG_EUSKERA = "eu";
    /**
     * Cdigo del idioma en ingls.
     */
    public static final String LANG_ENGLISH = "en";
    /**
     * Cdigo del idioma en francs.
     */
    public static final String LANG_FRENCH = "fr";
    /**
     * Cdigo del idioma en alemn.
     */
    public static final String LANG_DEUTCH = "de";

///////////////////////////////////////////////////////////////////////////////////////////
//  Procesos de Upload/Download
///////////////////////////////////////////////////////////////////////////////////////////

    /**
     * Tamao mximo permitido para las operaciones de download y upload de trozos de fichero.
     */
    public static final int BUFFER_SIZE_CHUNK_MAX = XMLProperties.get(R01MConstants.API_APPCODE,"dataStoreManager/maxBlockSize") != null ? XMLProperties.getInt(R01MConstants.API_APPCODE,"dataStoreManager/maxBlockSize")
                                                                                                                                 : 1000*1024;
    /**
     * Tamao mximo permitido para las operaciones de download y upload de ficheros pesados en procesos asncronos del rawDatastoreManager.
     */
    public static final int BUFFER_UPDOWN_SIZE_CHUNK_MAX = XMLProperties.get(R01MConstants.API_APPCODE,"dataStoreManager/maxBlockSize") != null ? XMLProperties.getInt(R01MConstants.API_APPCODE,"dataStoreManager/maxUpDownBlockSize")
                                                                                                                                 : 1000*1024;

///////////////////////////////////////////////////////////////////////////////////////////
// Constantes de configuracin
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Configuracin no visible por ningn componente de los gestores 
     */
    public static final String NONE_USAGE = "none";

    /**
     * Configuracin visible por todos los componentes de los gestores 
     */
    public static final String ALL_USAGE = "all";
///////////////////////////////////////////////////////////////////////////////////////////
//  Tipos de objetos en el registro del histrico
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Tipo de objeto desconocido.
     */
    public static final int OBJECT_UNKNOWN = -1;
    /**
     * Tipo de objeto contenido.
     */
    public static final int OBJECT_CONTENT = 0;
    /**
     * Tipo de objeto documento.
     */
    public static final int OBJECT_DOCUMENT = 1;
    /**
     * Tipo de objeto archivo de datos.
     */
    public static final int OBJECT_DATAFILE = 2;
    /**
     * Tipo de objeto portal.
     */
    public static final int OBJECT_PORTAL = 3;
    /**
     * Tipo de objeto pgina de portal.
     */
    public static final int OBJECT_PORTALPAGE = 4;
    /**
     * Pagina de portal en un idioma determinado
     */
    public static final int OBJECT_PORTALLANGPAGE = 5;
    /**
     * Tipo de objeto plantilla de presentacn de pginas de portal.
     */
    public static final int OBJECT_TEMPLATE = 6;
    /**
     * Tipo de objeto rea visual.
     */
    public static final int OBJECT_VA = 7;
    /**
     * Tipo de objeto: ficheros de indexacin de un contenido.
     */
    public static final int OBJECT_CONTENT_INDEX_FILES = 8;
    /**
     * Tipo de objeto: ficheros de indexacin de un documento.
     */
    public static final int OBJECT_DOCUMENT_INDEX_FILES = 9;
    /**
     * Tipo de objeto ficheros de indexacin de una pgina de portal.
     */
    public static final int OBJECT_PAGE_INDEX_FILES = 10;
    /**
     * Tipo de objeto: recursos adicionales de un contenido.
     */
    public static final int OBJECT_CONTENT_RESOURCE_FILES = 11;
    /**
     * Tipo de objeto: recursos adicionales de un portal.
     */
    public static final int OBJECT_PORTAL_RESOURCE_FILES = 12;
    /**
     * Tipo de objeto: ficheros de la workarea de sistema.
     */
    public static final int OBJECT_SYSTEM_RESOURCE_FILES = 13;
    /**
     * Tipo de objeto: Referencia al conjunto de AV dinamicas de un portal.
     */
    public static final int OBJECT_PORTAL_DYNAMIC_VAS = 14;
    /**
     * Tipo de objeto alias de documentos de un contenido.
     */
    public static final int OBJECT_CONTENT_ALIAS = 15;
    /**
     * Tipo de objeto alias de documento.
     */
    public static final int OBJECT_DOCUMENT_ALIAS = 16;
    /**
     * Tipo de objeto alias de pgina de portal.
     */
    public static final int OBJECT_PAGE_ALIAS = 17;
    /**
     * Tipo de objeto alias de portal.
     */
    public static final int OBJECT_PORTAL_ALIAS = 18;
    /**
     * cdigo mximo del tipo de objeto (para comprobaciones)
     */
    public static final int MAX_CODE_OF_OBJECT = 18;
    /**
     * Descripciones de los tipos de objeto
     */
    public static final String[] OBJECT_DESCS = new String[] {"content","document","dataFile",
                                                              "portal","page","langPage","template","av",
                                                              "contentIndexFiles","documentIndexFiles","pageIndexFiles",
                                                              "contentResourceFiles","portalResourceFiles","systemResourceFiles",
                                                              "portalDynamicVAs", "contentAlias", "documentAlias", "pageAlias",
                                                              "portalAlias"};
    /**
     * Objetos del gestor de contenidos
     */
    public static final List CONTENT_MODEL_OBJECT = Arrays.asList(new Object[] {new Integer(R01MConstants.OBJECT_CONTENT)
																	    ,new Integer(R01MConstants.OBJECT_CONTENT_INDEX_FILES)
																	    ,new Integer(R01MConstants.OBJECT_CONTENT_RESOURCE_FILES)
                                                                        ,new Integer(R01MConstants.OBJECT_CONTENT_ALIAS)
																	    ,new Integer(R01MConstants.OBJECT_DOCUMENT)
																	    ,new Integer(R01MConstants.OBJECT_DOCUMENT_INDEX_FILES)
                                                                        ,new Integer(R01MConstants.OBJECT_DOCUMENT_ALIAS)
																	    ,new Integer(R01MConstants.OBJECT_DATAFILE)});

    /**
     * Objetos del gestor de portales
     */
    public static final List PORTAL_MODEL_OBJECT = Arrays.asList(new Object[] {new Integer(R01MConstants.OBJECT_PORTALPAGE)
												                   ,new Integer(R01MConstants.OBJECT_PAGE_INDEX_FILES)
                                                                   ,new Integer(R01MConstants.OBJECT_PAGE_ALIAS)
												                   ,new Integer(R01MConstants.OBJECT_VA)
												                   ,new Integer(R01MConstants.OBJECT_PORTAL_DYNAMIC_VAS)
                                                                   ,new Integer(R01MConstants.OBJECT_PORTAL_ALIAS)
												                   ,new Integer(R01MConstants.OBJECT_PORTAL_RESOURCE_FILES)
												                   ,new Integer(R01MConstants.OBJECT_SYSTEM_RESOURCE_FILES)});

///////////////////////////////////////////////////////////////////////////////////////////
//  Constantes para la cookie de IW
///////////////////////////////////////////////////////////////////////////////////////////

    /**
     * Cookie de IW, identificador del usuario.
     */
    public static final String IW_USER_ID = "contentServices/clientAuthentication/userName";
    /**
     * Cookie de IW, password del usuario.
     */
    public static final String IW_USER_PASSWORD = "contentServices/clientAuthentication/userPassword";
    /**
     * Cookie de IW, role del usuario.
     */
    public static final String IW_USER_ROLE = "contentServices/clientAuthentication/userRole";
    /**
     * Cookie de IW, factora cliente.
     */
    public static final String IW_SERVICE_FACTORY = "contentServices/serviceFactory";
    /**
     * Cookie de IW, identificador del host.
     */
    public static final String IW_HOST_NAME = "contentServices/serviceBaseURL/hostName";
    /**
     * Cookie de IW, identificador del puerto.
     */
    public static final String IW_PORT = "contentServices/serviceBaseURL/port";
    /**
     * Cookie de IW, identificador del protocolo.
     */
    public static final String IW_PROTOCOL = "contentServices/serviceBaseURL/protocol";

///////////////////////////////////////////////////////////////////////////////////////////
//  Encoding
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Charset de la mquina de Interwoven.
     */
    public static final String CHARSET_IW = XMLProperties.get(R01MConstants.API_APPCODE,"contentServices/encoding/iw");
    /**
     * Charset de la mquina de Weblogic.
     */
    public static final String CHARSET_WEBLOGIC = XMLProperties.get(R01MConstants.API_APPCODE,"contentServices/encoding/weblogic");
    /**
     * Mismo charset de Interwoven y Weblogic.
     */
    public static final boolean CHARSET_SAME = true; //CHARSET_IW.equals(CHARSET_WEBLOGIC) ? true:false;
    /**
     * Encoding por defecto para el web
     */
    public static final String DEFAULT_WEB_ENCODING = XMLProperties.get(R01MConstants.API_APPCODE,"searchEngine/encoding/web","ISO-8859-1");

///////////////////////////////////////////////////////////////////////////////////////////
//  DEBUG
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Habilitar la inclusion del firebug para IE
     * (incluye el script <script type='text/javascript' src='http://getfirebug.com/releases/lite/1.2/firebug-lite-compressed.js'></script>)
     */
    public static final boolean DEBUG_HTML = XMLProperties.getBoolean(R01MConstants.API_APPCODE,"debug/html",false);

///////////////////////////////////////////////////////////////////////////////////////////
//  REFERENCIADOR
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Habilitar la inclusion del nuevo referenciador
     * (incluye el script <script type='text/javascript' src='http://getfirebug.com/releases/lite/1.2/firebug-lite-compressed.js'></script>)
     */
    public static final boolean NEW_REFERENCER = XMLProperties.getBoolean(R01MConstants.API_APPCODE,"newReferencer",false);    
    
///// /////////////////////////////////////////////////////////////////////////////////////////
// PAGINA PREVIEW
///////////////////////////////////////////////////////////////////////////////////////////
    public static final String PREV_PAGE=XMLProperties.get(R01MConstants.API_APPCODE, "previewPage", "r01-iwprev/es");

///////////////////////////////////////////////////////////////////////////////////////////
//  PUBLICACION
///////////////////////////////////////////////////////////////////////////////////////////
    public static final String CONTENT_PUBLISHER_MANAGER = XMLProperties.get(R01MConstants.API_APPCODE, "publisherManager/contentPublishConfiguration", "com.ejie.r01m.objects.publisher.R01MContentPublisherManager");

    public static final String PORTAL_PUBLISHER_MANAGER = XMLProperties.get(R01MConstants.API_APPCODE, "publisherManager/portalPublishConfiguration", "com.ejie.r01m.objects.publisher.R01MPortalPublisherManager");

    /**
     * Pasos del proceso de publicacin
     */
    public static final int PREPARE_TO_PUBLISH = 0;
    public static final int PRE_PUBLISH = 1;
    public static final int PUBLISH = 2;
    public static final int POST_PUBLISH = 3;

///////////////////////////////////////////////////////////////////////////////////////////
//  INDEXACION
///////////////////////////////////////////////////////////////////////////////////////////

    public static final String CONTENT_INDEXER_MANAGER = XMLProperties.get(R01MConstants.API_APPCODE, "indexerManager/contentIndexConfiguration", "com.ejie.r01m.objects.searchengine.indexer.R01MContentIndexerManager");

    public static final String PORTAL_INDEXER_MANAGER = XMLProperties.get(R01MConstants.API_APPCODE, "indexerManager/portalIndexConfiguration", "com.ejie.r01m.objects.searchengine.indexer.R01MPortalIndexerManager");

    public static final String DOCUMENT_INDEX_FOLDER = XMLProperties.get(R01MConstants.API_APPCODE, "indexerManager/documentIndexFolder", "r01Index");

    public static final String CONTENT_INDEX_FOLDER = XMLProperties.get(R01MConstants.API_APPCODE, "indexerManager/contentIndexFolder", "r01Index");

    ///////////////////////////////////////////////////////////////////////////////////////////
//  OTROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Lista de nodos del cluster de WL
     */
    public static final List WL_NODES_CLUSTER_HTTP = XMLProperties.getPropertyList("r01m","weblogicCluster/http/weblogicNode");
    /**
     * Lista de nodos del cluster de WL
     */
    public static final List WL_NODES_CLUSTER_T3 = XMLProperties.getPropertyList("r01m","weblogicCluster/t3/weblogicNode");
    /**
     * Lista de nodos del cluster de WL
     */
    public static final Map WL_NODES_CLUSTER = new HashMap();
    static {
        WL_NODES_CLUSTER.put("http",WL_NODES_CLUSTER_HTTP);
        WL_NODES_CLUSTER.put("t3",WL_NODES_CLUSTER_T3);
    }
    /**
     * Acciones sobre cache, actualizar
     */
    public static final int CACHE_UPDATE = 1;
    /**
     * Acciones sobre cache, baja
     */
    public static final int CACHE_DELETE = 2;

    /**
     * Prefijo de los identificadores para las Areas Visuales migradas
     */
    public static final String PORTALMIGRATE_OID_PREFIX = XMLProperties.getProperty(R01MConstants.API_APPCODE, "migratePortalOidPrefix");

    /**
     * Tipos de metadatos para la indexacin particionada (indexacin por distintos ficheros idx o ciertos campos de BD)
     */
    public static final String INDEX_CATALOG_CODE = "catalog.idx";
    public static final String INDEX_TYPOLOGY_CODE = "typology.idx";
    public static final String INDEX_STORAGE_CODE = "storage.idx";
    public static final String INDEX_CONTENT_CODE = "content.idx";
    
    public static final String INDEX_APACHE_CATALOG_CODE = "r01ContVars.catalog.shtml";
    public static final String INDEX_APACHE_TYPOLOGY_CODE = "r01ContVars.typology.shtml";
    public static final String INDEX_APACHE_STORAGE_CODE = "r01ContVars.storage.shtml";
    public static final String INDEX_APACHE_CONTENT_CODE = "r01ContVars.content.shtml";
    

    /**
     * Tipo de indexacin
     */
    public static final int INDEX_TYPE_INDEX = 0;
    public static final int INDEX_TYPE_UNINDEX = 1;

    // Inicializar
    static {
        if (QUERY_RESULTS_MAPFILE == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad xoMappingFiles/queryAndResults en el fichero r01m.properties.xml: NO SE PUEDE UTILIZAR EL BUSCADOR!!!!");
        }
        if (CONTENTMODEL_MAPFILE == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad xoMappingFiles/contentModel en el fichero r01m.properties.xml: NO SE PUEDE UTILIZAR EL GESTOR DE CONTENIDOS!!!!");
        }
        if (PORTALMODEL_MAPFILE == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad xoMappingFiles/portalModel en el fichero r01m.properties.xml: NO SE PUEDE UTILIZAR EL GESTOR DE PORTALES!!!!");
        }
        if (CONFIGCONTENTMODEL_MAPFILE == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad xoMappingFiles/configContentModel en el fichero r01m.properties.xml: NO SE PUEDE UTILIZAR LOS CARGADORES DEL GESTOR DE CONTENIDOS!!!!");
        }
        if (CONFIGPORTALMODEL_MAPFILE == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad xoMappingFiles/configPortalModel en el fichero r01m.properties.xml: NO SE PUEDE UTILIZAR LOS CARGADORES DEL GESTOR DE PORTALES!!!!");
        }
        if (PUBLISHEROBJECTS_MAPFILE == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad xoMappingFiles/publisherObjects en el fichero r01m.properties.xml: NO SE PUEDE UTILIZAR EL PUBLICADOR!!!!");
        }
        if (URLREFERENCER_MAPFILE == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad xoMappingFiles/xmlUrlReferencerMapping en el fichero r01m.properties.xml: NO SE PUEDE UTILIZAR EL REFERENCIADOR!!!!");
        }
        if (PUBLISHERMODEL_MAPFILE == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad xoMappingFiles/publisherModel en el fichero r01m.properties.xml: NO SE PUEDE UTILIZAR EL PUBLICADOR!!!!");
        }
        if (INDEXABLEOBJECTS_MAPFILE == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad xoMappingFiles/indexableObjects en el fichero r01m.properties.xml: NO SE PUEDE INDEXAR!!!!");
        }
        if (WL_NODES_CLUSTER == null) {
            R01FLog.to("r01m.util").severe("No est definida la propiedad weblogicCluster/weblogicNode en el fichero r01m.properties.xml: NO SE PUEDE RECARGAR CACHES!!!!");
        }
    }

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES PARA EL CONTROL DE CIERTAS FUNCIONALIDADES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Flag que indica si se debe validar el TS de contenidos y documentos
     */
    public static final int VALIDATE_CONTENT_MODEL_TS = XMLProperties.get(R01MConstants.API_APPCODE,"flags/validateTS","0") != null && NumberUtils.isInteger(XMLProperties.get(R01MConstants.API_APPCODE,"flags/validateTS","0")) ? Integer.parseInt(XMLProperties.get(R01MConstants.API_APPCODE,"flags/validateTS","0")) : Integer.parseInt("0");
    
    /**
     * Indica la forma de hacer la subida de los ficheros
     */
    /**
     * La subida es todo el fichero de golpe
     */
    public static final String AT_ONCE = "atOnce";
    
    /**
     * La subida es mediante chunk
     */
    public static final String CHUNKED = "chunked";
    
    
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MConstants() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS AUXILIARES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Obtiene el literal asociado al valor del tipo de objeto
     * @param objectType el tipo de objeto
     * @return el literal que representa al valor numrico
     */
    public static String getObjectDesc(int objectType) {
    	if(objectType >= 0 && objectType < MAX_CODE_OF_OBJECT) {
			return R01MConstants.OBJECT_DESCS[objectType];
		}
    	return "Tipo de objeto desconocido";
    }
}
