package com.ejie.r01m.objects.urlreference;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 
 */
public class R01MUrlResult implements Serializable{
    private static final long serialVersionUID = 6258256505019574622L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////    
	/**
     * Url que se referencia
	 */
	private String refUrl ="";
    /**
     * Cdigo html de la url (<a href=...>)
     */
	private String refUrlHTML;
    /**
     * Texto de un enlace
     */
	private String refText;
    /**
     * <pre>
     * Lista de mapas de los resultados.
     * Consultar las claves para contenidos en {@link com.ejie.r01m.utils.searchengine.R01MSearchResultsFormatterConstants},<br>
     *      - contentOid:   identificador del contenido
     *      - documentOid:  identificador del documento
     *      - searchGUID:   identificador de la query almacenada
     *      - queryXML:     xml de la bsqueda 
     * para la query en {@link com.ejie.r01m.utils.R01MConstantsUrlReferenceConfig}.
     * </pre>
     * @see com.ejie.r01m.utils.searchengine.R01MSearchResultsFormatterConstants
     * @see com.ejie.r01m.utils.R01MConstantsUrlReferenceConfig
     */
	private Map resultDetail;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
	/**
     * Constructor vaco.<br>
     * Se inicializan los atributos a null, excepto resultDetail, a un mapa vaco
	 */
    public R01MUrlResult() {
        super();
		refUrl = "";
		refUrlHTML = "";
		resultDetail = new HashMap();
		refText = "";
	}

///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * @return Returns the refUrl.
     */
    public String getRefUrl() {
    	return refUrl;
    }
    /**
     * @param newRefUrl The refUrl to set.
     */
    public void setRefUrl(String newRefUrl) {
    	this.refUrl = newRefUrl;
    }
    /**
     * @return Returns the refUrlHTML.
     */
    public String getRefUrlHTML() {
    	return refUrlHTML;
    }
    /**
     * @param newRefUrlHTML The refUrlHTML to set.
     */
    public void setRefUrlHTML(String newRefUrlHTML) {
    	this.refUrlHTML = newRefUrlHTML;
    }    
    /**
     * @return Returns the resultDetail.
     */
    public Map getResultDetail() {
    	return resultDetail;
    }        
    /**
     * @param newResultDetail The resultDetail to set.
     */
    public void setResultDetail(Map newResultDetail) {
    	this.resultDetail = newResultDetail;
    }
    /**
     * @return Returns the refText.
     */
    public String getRefText() {
    	return refText;
    }
    /**
     * @param theRefText The refText to set.
     */
    public void setRefText(String theRefText) {
    	this.refText = theRefText;
    }

}
