package com.ejie.r01m.objects.urlreference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejie.r01f.util.R01FProperties;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MConstantsUrlReferenceConfig;
import com.ejie.r01m.utils.searchengine.R01MSearchResultsFormatterConstants;

/**
 * Objeto de definicin de la url de referenciacin.
 */
public class R01MUrlReference implements Serializable{
    private static final long serialVersionUID = -5807810895705661872L;
///////////////////////////////////////////////////////////////////////////////////////////
//  TEXTO ALTERNATIVO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Texto alternativo.
     */
    public String refTextAlt;
    /**
     * Apariencia de la ventana donde se va a abrir el link.
     */
    public R01MUrlReferenceWindowAppearance refWindowAppearance;
    /**
     * Tipo de URL.
     * @see R01MConstantsUrlReferenceConfig
     */
    public int refUrlType;
    /**
     * Mapa con la descripcion del tipo de URL en  los diferentes idiomas.
     */
    public Map refUrlTypeDesciption;
    /**
     * <pre>
     * Lista de objetos {@link R01MUrlResult}.
     * - Si se trata de un enlace "normal" viene el enlace en un objeto R01MUrlResult
     * - Si se trata de una bsquead, en la lista refResults puede venir:
     *      (0) -> Puede ser la query en xml o directamente un resultado de bsqueda pre-seleccionado
     *             si el usuario no ha puesto ninguna condicion de filtro (no hay query y se buscan todos
     *             los contenidos)
     *      (1) -> un resultado de busqueda pre-seleccionado
     *      (2) -> otro resultado de busqueda pre-seleccionado
     *      ....
     * </pre>
     */
    public List refResults;
    /**
     * Objeto de la pgina de presentacin.
     */
    public R01MUrlReferencePresentationPage pageObject;
    /**
     * Indica si se debe recuperar la informacion del usuario.
     */
    public String userInfoCollecter;
    
    /**
     * Mapa con los eventos javascript
     * Donde key es el evento y value el js a ejecutar
     */
    
    public Map jsEvents;

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco.<br>
     * Se inicializan los atributos a los valores por defecto.
     */
    public R01MUrlReference(){
        super();
        refTextAlt = null;
        refWindowAppearance = new R01MUrlReferenceWindowAppearance();
        refUrlType = R01MConstantsUrlReferenceConfig.TYPE_EXTERNAL_URL;
        refUrlTypeDesciption = new HashMap();
        refResults = new ArrayList();
        pageObject= new R01MUrlReferencePresentationPage();
        userInfoCollecter = "false";
        jsEvents = new HashMap();
        /*Inicializamos el mapa con los valores del xml*/
        List jsList = R01FProperties.getPropertyList(R01MConstants.USERINTERFACE_APPCODE, "referencer/jsEvents/jsEvent");    
        if(jsList!=null && !jsList.isEmpty()) {
            for(int i=0; i<jsList.size(); i++) {
                jsEvents.put(jsList.get(i),"");
            }
        }
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the refUrlTypeDesciption.
     */
    public Map getRefUrlTypeDesciption() {
        return refUrlTypeDesciption;
    }
    /**
     * @param theRefUrlTypeDesciption The refUrlTypeDesciption to set.
     */
    public void setRefUrlTypeDesciption(Map theRefUrlTypeDesciption) {
        this.refUrlTypeDesciption = theRefUrlTypeDesciption;
    }
    /**
     * @return Returns the pageObject.
     */
    public R01MUrlReferencePresentationPage getPageObject() {
        return pageObject;
    }
    /**
     * @param thePageObject The pageObject to set.
     */
    public void setPageObject(R01MUrlReferencePresentationPage thePageObject) {
        this.pageObject = thePageObject;
    }
    /**
     * @return Returns the refResults.
     */
    public List getRefResults() {
        return refResults;
    }
    /**
     * Devuelve un resultado cuyo indice se pasa como parmetro.
     * @param index ndice.
     * @return el objeto {@link R01MUrlResult} o <code>null</code> si no se encuentra.
     */
    public R01MUrlResult getRefResult(int index) {
        if (this.getRefResults() == null || index > this.getRefResults().size()-1) return null;
        return (R01MUrlResult)this.getRefResults().get(index);
    }
    /**
     * @param theRefResults The refResults to set.
     */
    public void setRefResults(List theRefResults) {
        this.refResults = theRefResults;
    }
    /**
     * @return Returns the refTextAlt.
     */
    public String getRefTextAlt() {
        return refTextAlt;
    }
    /**
     * @param theRefTextAlt The refTextAlt to set.
     */
    public void setRefTextAlt(String theRefTextAlt) {
        this.refTextAlt = theRefTextAlt;
    }
    /**
     * @return Returns the refWindowAppearance.
     */
    public R01MUrlReferenceWindowAppearance getRefWindowAppearance() {
        return refWindowAppearance;
    }
    /**
     * @param theRefWindowAppearance The refWindowAppearance to set.
     */
    public void setRefWindowAppearance(R01MUrlReferenceWindowAppearance theRefWindowAppearance) {
        this.refWindowAppearance = theRefWindowAppearance;
    }
    /**
     * @return Returns the userInfoCollecter.
     */
    public String getUserInfoCollecter() {
        return userInfoCollecter;
    }
    /**
     * @param theUserInfoCollecter The userInfoCollecter to set.
     */
    public void setUserInfoCollecter(String theUserInfoCollecter) {
        this.userInfoCollecter = theUserInfoCollecter;
    }
    /**
     * @return the refUrlType
     */
    public int getRefUrlType() {
        return this.refUrlType;
    }
    /**
     * @param theRefUrlType The refUrlType to set.
     */
    public void setRefUrlType(int theRefUrlType) {
        this.refUrlType = theRefUrlType;
    }
    /**
     * Extrae el atributo refText del primer elemento de la lista de resultados
     * @return el texto del enlace, null si no existe
     */
    public String getRefText() {
        if(this.getRefResults()!=null && ! this.getRefResults().isEmpty()) {
            return ((R01MUrlResult)this.getRefResults().get(0)).getRefText();
        }
        return null;
    }
    /**
     * Obtiene el enlace (hipervnculo) asociado al referenciador.
     * @return el enlace, si no est definido la cadena vaca.
     */
    public String getRefLink() {
        if(this.getRefResults()!=null && ! this.getRefResults().isEmpty()) {
            return ((R01MUrlResult)this.getRefResults().get(0)).getRefUrl();
        }
        return "";
    }
    

    /**
     * @return the jsEvents
     */
    public Map getJsEvents() {
        return this.jsEvents;
    }
    /**
     * @param theJsEvents The jsEvents to set.
     */
    public void setJsEvents(Map theJsEvents) {
        this.jsEvents = theJsEvents;
    }
    // /////////////////////////////////////////////////////////////////////////////////////////
// METODOS AUXILIARES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Compone la URL final teniendo en cuenta la recogida de la informacin del usuario.
     * @param lang idioma del componente de captura de inf. usu.
     * @param referencerUrl la url a redireccionar despus de la captura de la inf. usu.
     * @return la url final
     */
    public StringBuffer getRefUrl(String lang,
                            	  String referencerUrl) {
        StringBuffer url = new StringBuffer();
        url.append(referencerUrl);

        return url;
    }
    /**
     * Obtener el identificador del contenido del objeto referenciador.
     * @return identificador del contenido, vacio si no existe enlace a contenido
     */
     public String getRefContentOid() {
                 if (this.getRefResults()!=null
                 && !this.getRefResults().isEmpty()
                 && ((R01MUrlResult)this.getRefResults().get(0)).getResultDetail() != null
                 && !((R01MUrlResult)this.getRefResults().get(0)).getResultDetail().isEmpty()
                 && ((R01MUrlResult)this.getRefResults().get(0)).getResultDetail().containsKey(R01MSearchResultsFormatterConstants.CONTENT_OID)) {
             return ((R01MUrlResult)this.getRefResults().get(0)).getResultDetail().get(R01MSearchResultsFormatterConstants.CONTENT_OID).toString();
         }
         return "";
     }
     /**
      * Obtener el identificador del documento del objeto referenciador.
     * @return identificador del documento, vacio si no existe enlace a contenido
      */
     public String getRefDocumentOid() {
                 if (this.getRefResults()!=null
                 && !this.getRefResults().isEmpty()
                 && ((R01MUrlResult)this.getRefResults().get(0)).getResultDetail() != null
                 && !((R01MUrlResult)this.getRefResults().get(0)).getResultDetail().isEmpty()
                 && ((R01MUrlResult)this.getRefResults().get(0)).getResultDetail().containsKey(R01MSearchResultsFormatterConstants.DOCUMENT_OID)) {
             return ((R01MUrlResult)this.getRefResults().get(0)).getResultDetail().get(R01MSearchResultsFormatterConstants.DOCUMENT_OID).toString();
         }
         return "";
     }
     /**
      * Obtener el identificador del repositorio de publicacin del documento del objeto referenciador.
     * @return identificador del repositorio de publicacin del documento, vacio si no existe enlace a contenido.
      */
     public String getRefDocumentRepositoryOid() {
         if(this.getRefResults()!=null
                 && !this.getRefResults().isEmpty()
                 && ((R01MUrlResult)this.getRefResults().get(0)).getResultDetail() != null
                 && !((R01MUrlResult)this.getRefResults().get(0)).getResultDetail().isEmpty()
                 && ((R01MUrlResult)this.getRefResults().get(0)).getResultDetail().containsKey(R01MSearchResultsFormatterConstants.DOCUMENT_PUBLISH_REPOSITORY)) {
             return ((R01MUrlResult)this.getRefResults().get(0)).getResultDetail().get(R01MSearchResultsFormatterConstants.DOCUMENT_PUBLISH_REPOSITORY).toString();
         }
         return "";
     }
}
