package com.ejie.r01m.objects.urlreference;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.utils.R01MConstantsUrlReferenceConfig;

/**
 * @author co01556e
 *
 */
public class R01MHtmlLink implements Serializable {

    private static final long serialVersionUID = -7456177936786946926L;

///////////////////////////////////////////////////////////////////////////////////////////
//  MEMBERS
///////////////////////////////////////////////////////////////////////////////////////////

    /**
     * Apertura del link
     */
    public String a = "";
    /**
     * Tipo de url
     */
    public int urltype = R01MConstantsUrlReferenceConfig.TYPE_EXTERNAL_URL;
    /**
     * Texto alternativo del enlace
     */
    public String alt = "";
    /**
     * Titulo del enlace
     */
    public String title = "";
    /**
     * Titulo del enlace
     */
    public String target = "";
    /**
     * url en caso de que el enlace sea en la misma ventana
     */
    public String href = "";
    /**
     * Url en el caso de que sea en otra ventana
     */
    public String onmousedown = "";
    /**
     * Url en el caso de que sea en otra ventana
     */
    public String onkeypress = "";
    /**
     * Url en el caso de un click en ancla del Editor Tiny y guardar su contenido
     */
    public String mce_onclick = "";
    /**
     * Identificador del Editor Tiny
     */
    public String editor_id = "";
    /**
     * Url en el caso de un click en ancla del Editor Tiny
     */
    public String onclick = "";

    private static final String[] attributes = { "urlType", "alt", "title", "target", "href", "onmousedown", "onkeypress", "mce_onclick", "editor_id", "onclick" };

    ///////////////////////////////////////////////////////////////////////////////////////////
    //  CONSTRUCTORS
    ///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MHtmlLink() {
        super();
    }

    ///////////////////////////////////////////////////////////////////////////////////////////
    //  GETTERS & SETTERS
    ///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the a.
     */
    public String getA() {
        return a;
    }
    /**
     * @param newA The a to set.
     */
    public void setA(String newA) {
        this.a = newA;
    }
    /**
     * @return Returns the href.
     */
    public String getHref() {
        return href;
    }
    /**
     * @param theHref The href to set.
     */
    public void setHref(String theHref) {
        this.href = theHref;
    }
    /**
     * @return Returns the onmousedown.
     */
    public String getOnmousedown() {
        return onmousedown;
    }
    /**
     * @param theOnmousedown The onmousedown to set.
     */
    public void setOnmousedown(String theOnmousedown) {
        this.onmousedown = theOnmousedown;
    }

    /**
     * @return the urltype
     */
    public int getUrltype() {
        return this.urltype;
    }

    /**
     * @param theUrltype The urltype to set.
     */
    public void setUrltype(int theUrltype) {
        this.urltype = theUrltype;
    }

    /**
     * @return the title
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * @param theTitle The theTitle to set.
     */
    public void setTitle(String theTitle) {
        this.title = theTitle;
    }

    /**
     * @return Returns the alt.
     */
    public String getAlt() {
        return alt;
    }

    /**
     * @param theAlt The alt to set.
     */
    public void setAlt(String theAlt) {
        this.alt = theAlt;
    }
    /**
     * @return the onkeypress
     */
    public String getOnkeypress() {
        return this.onkeypress;
    }

    /**
     * @param theOnkeypress The onkeypress to set.
     */
    public void setOnkeypress(String theOnkeypress) {
        this.onkeypress = theOnkeypress;
    }


    /**
     * @return the mce_onclick
     */
    public String getMce_onclick() {
        return this.mce_onclick;
    }

    /**
     * @param theMceOnclick The mce_onclick to set.
     */
    public void setMce_onclick(String theMceOnclick) {
        this.mce_onclick = theMceOnclick;
    }

    /**
     * @return the editor_id
     */
    public String getEditor_id() {
        return this.editor_id;
    }

    /**
     * @param theEditorId The editor_id to set.
     */
    public void setEditor_id(String theEditorId) {
        this.editor_id = theEditorId;
    }

    /**
     * @return the onclick
     */
    public String getOnclick() {
        return this.onclick;
    }

    /**
     * @param theOnclick The onclick to set.
     */
    public void setOnclick(String theOnclick) {
        this.onclick = theOnclick;
    }

    /**
     * Valida que los atributos estn correctamente para ser mapeados
     * @param htmlTag
     * @return newHtmlTag
     */
    public static String validateHtmlTagAttributes(String htmlTag) {
        String newHtmlTag = htmlTag;
        for (int i = 0;i < attributes.length;i++) {
            newHtmlTag = validateHtmlTagAttribute(newHtmlTag, attributes[i]);
        }
        return newHtmlTag;
    }
    /**
     * Valida el atributos es correcto para ser parseado
     * @param htmlTag
     * @param attribute
     * @return newHtmlTag
     */
    public static String validateHtmlTagAttribute(String htmlTag,
                                                  String attribute) {
        String newHtmlTag = htmlTag;
        int indexOfAttribute = newHtmlTag.indexOf(attribute + "=\"");
        if (indexOfAttribute != -1)
            return newHtmlTag;
        indexOfAttribute = newHtmlTag.indexOf(attribute + "=");
        if (indexOfAttribute == -1)
            return newHtmlTag;
        int indexOfValue = indexOfAttribute + attribute.length() + 1;
        int indexOfValueEnd = newHtmlTag.indexOf(" ", indexOfValue);
        if (indexOfValueEnd == -1) {//No encuentra el final del atributo pq esta justo al lado del cierre de la etiqueta carater'>'
            indexOfValueEnd = newHtmlTag.indexOf(">", indexOfValue);
        }

        String value = newHtmlTag.substring(indexOfValue, indexOfValueEnd);
        String fullAttribute = attribute + "=" + value;
        newHtmlTag = newHtmlTag.replaceAll(fullAttribute, attribute + "=\"" + value + "\"");

        return newHtmlTag;
    }

    /**
     * @param args
     */
    public static void main(String[] args) {
        R01MHtmlLink htmlLink = new R01MHtmlLink();
        htmlLink.setA("texto");
        htmlLink.setHref("urlQue se");
        //htmlLink.setTitle("title alternativo");
        htmlLink.setUrltype(R01MConstantsUrlReferenceConfig.TYPE_EXTERNAL_URL);
        htmlLink.setOnmousedown("");

        String pathMap = "d:/eAdmin/aplic/r01m/html/datos/r01mHtmlLinkMap.xml";
        try {
            String xml = XOManager.getXML(pathMap, htmlLink);

            R01FLog.to("r01m.test").fine("xml: " + xml);

        } catch (XOMarshallerException maEx) {
            R01FLog.to("r01m.test").fine(maEx.getMessage() + "," + maEx);
        }
    }

    /**
     * @return the target
     */
    public String getTarget() {
        return this.target;
    }

    /**
     * @param theTarget The target to set.
     */
    public void setTarget(String theTarget) {
        this.target = theTarget;
    }

}
