package com.ejie.r01m.objects.searchengine.session;


import r01f.util.types.collections.CollectionUtils;
import r01mo.model.oids.R01MStorageOIDs.R01MStorageAreaID;
import r01mo.model.oids.R01MStorageOIDs.R01MStorageServerID;
import r01mo.model.oids.R01MStorageOIDs.R01MStorageStoreID;
import r01mo.model.oids.R01MStorageOIDs.R01MStorageWorkAreaID;
import r01mo.model.oids.R01MStructuresOIDs.R01MStructureLabelOID;
import r01mo.model.oids.R01MTypoOIDs.R01MTypoClusterID;
import r01mo.model.oids.R01MTypoOIDs.R01MTypoFamilyID;
import r01mo.model.oids.R01MTypoOIDs.R01MTypoTypeID;
import r01mo.model.search.query.R01MSearchQuery;
import r01mo.model.search.query.metadata.R01MSearchQueryMetaData;
import r01mo.model.search.query.metadata.R01MSearchQueryOrderByMetaData;
import r01mo.model.search.results.presentation.R01MSearchResultsPresentation;

import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData;

/**
 * Convierte una query v3 en una query v2
 */
public class R01MSearchQueryConverter {
	/**
	 * Convierte una query v3 en una query v2
	 * @param qry la query v3
	 * @return la query v2
	 */
	public static R01MQueryObject convert(final R01MSearchQuery qry,
										  final R01MSearchResultsPresentation presentation) {
		if (qry == null) return null;
		R01MQueryObject outQry = new R01MQueryObject();
		
		// Estructuras de catalogacin
		if (!CollectionUtils.isNullOrEmpty(qry.getStructureLabelsAND())) {
			for (R01MStructureLabelOID l : qry.getStructureLabelsAND()) {
				outQry.addANDStructureCatalog(l.asString());
			}
		}
		if (!CollectionUtils.isNullOrEmpty(qry.getStructureLabelsOR())) {
			for (R01MStructureLabelOID l : qry.getStructureLabelsAND()) {
				outQry.addORStructureCatalog(l.asString());
			}			
		}
		// MetaData AND
		if (!CollectionUtils.isNullOrEmpty(qry.getMetaDataAND())) {
			for (R01MSearchQueryMetaData md : qry.getMetaDataAND()) {
				outQry.addMetaData(md.getOid().asString(),md.getConditionAsString(),md.getValueAsString());
			}
		}
		// MetaData OR
		if (!CollectionUtils.isNullOrEmpty(qry.getMetaDataOR())) {
			throw new IllegalArgumentException("MetaData or conditions NOT supported in v2!");
		}
		// Tipologa
		if (!CollectionUtils.isNullOrEmpty(qry.getTypoClusters())) {
			for (R01MTypoClusterID c : qry.getTypoClusters()) {
				outQry.addContentCluster(c.asString());
			}
		}
		if (!CollectionUtils.isNullOrEmpty(qry.getTypoFamilies())) {
			for (R01MTypoFamilyID f : qry.getTypoFamilies()) {
				outQry.addContentFamily(f.asString());
			}
		}
		if (!CollectionUtils.isNullOrEmpty(qry.getTypoTypes())) {
			for (R01MTypoTypeID t : qry.getTypoTypes()) {
				outQry.addContentType(t.asString());
			}
		}
		// Almacenamiento
		if (!CollectionUtils.isNullOrEmpty(qry.getStorageServers())) {
			for (R01MStorageServerID s : qry.getStorageServers()) {
				outQry.addServer(s.asString());
			}
		}
		if (!CollectionUtils.isNullOrEmpty(qry.getStorageStores())) {
			for (R01MStorageStoreID d : qry.getStorageStores()) {
				outQry.addDataRepository(CollectionUtils.of(qry.getStorageServers()).pickOneAndOnlyElement().asString(),
										 d.asString());
			}
		}
		if (!CollectionUtils.isNullOrEmpty(qry.getStorageAreas())) {
			for (R01MStorageAreaID a : qry.getStorageAreas()) {
				outQry.addArea(CollectionUtils.of(qry.getStorageServers()).pickOneAndOnlyElement().asString(),
							   CollectionUtils.of(qry.getStorageStores()).pickOneAndOnlyElement().asString(),
							   a.asString());
			}
		}
		if (!CollectionUtils.isNullOrEmpty(qry.getStorageWorkAreas())) {
			for (R01MStorageWorkAreaID w : qry.getStorageWorkAreas()) {
				outQry.addArea(CollectionUtils.of(qry.getStorageServers()).pickOneAndOnlyElement().asString(),
							   CollectionUtils.of(qry.getStorageStores()).pickOneAndOnlyElement().asString(),
							   CollectionUtils.of(qry.getStorageAreas()).pickOneAndOnlyElement().asString(),
							   w.asString());
			}
		}
		// Ordenacion
		if (!CollectionUtils.isNullOrEmpty(qry.getOrderByMetadata())) {
			for (R01MSearchQueryOrderByMetaData o : qry.getOrderByMetadata()) {
				outQry.addOrderByMetaData(new R01MSearchedOrderByMetaData(o.getMetaDataOid().asString(),o.getOrder().getCode()));
			}
		}
		
		// Presentacin
		if (presentation != null) {
			outQry.setPresentationProperty("r01PageSize",Integer.toString(presentation.getResultsPerPage()));
		}
		return outQry;
	}
}
