/*
 * Created on Jan 7, 2006
 * 
 * @author IE00165H - Alex Lara
 * (c) 2006 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;

/**
 * <pre>
 * Resultado de la fase de inicializacin de TODOS LOS ORIGENES.
 * En este objeto se agrupan los resultados de la fase de inicializacin en todos los orgenes de bsqueda.
 * </pre>
 */
public class R01MSessionSearchInitResult implements Serializable {
    private static final long serialVersionUID = -5058303733481482748L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MEMBERS
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Identificador de la sesin.
     */
    public String sessionOid;
    /**
     * <pre>
     * Resultados de la inicializacin en cada uno de los orgenes (objetos {@link R01MSearchSourceInitResult})
     * OJO!! Se utiliza un hashtable ya que es posible un acceso al miembro por varios threads.
     * </pre>
     */
    public Map sourcesInitResults = new Hashtable();
    /**
     * Tiempo que se ha tardado en hacer la inicializacin de todos los orgenes de 
     * resultados.
     */
    public long initPerformMillis = Long.MIN_VALUE;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////       
    /**
     * Constructor vaco
     */
    public R01MSessionSearchInitResult() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * <pre>
     * Aade los resultados de la inicializacin de un origen al mapa de resultados
     * indexada por oid de origen. 
     * A este mtodo se llama desde el listener de eventos de inicializacin de orgenes.
     * </pre>
     * @param srcSrchInitResult el resultado de la inicializacin del origen
     * @param srcInitPerformMillis los milisegundos que se ha tardado en inicializar el origen
     */
    public void addSourceInitResult(R01MSearchSourceInitResult srcSrchInitResult,long srcInitPerformMillis) {
        // OJO! se utiliza una Hashtable ya que puede haber acceso concurrente al objeto
        srcSrchInitResult.setInitPerformMillis(srcInitPerformMillis);
        this.sourcesInitResults.put(srcSrchInitResult.getSourceOid(),srcSrchInitResult);
    }
    /**
     * Obtiene el resultado de inicializacin de un origen.
     * @param srcId Identificador del origen
     * @return el objeto {@link R01MSearchSourceInitResult} con el resultado de la 
     *         inicializacin del origen
     */
    public R01MSearchSourceInitResult getSourceInitResult(String srcId) {
        return this.sourcesInitResults == null ? null:(R01MSearchSourceInitResult)this.sourcesInitResults.get(srcId);
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * @return Returns the sessionOid.
     */
    public String getSessionOid() {
        return this.sessionOid;
    }
    /**
     * @param theSessionOid The sessionOid to set.
     */
    public void setSessionOid(String theSessionOid) {
        this.sessionOid = theSessionOid;
    }
    /**
     * @return Returns the sourcesInitResults.
     */
    public Map getSourcesInitResults() {
        return this.sourcesInitResults;
    }
    /**
     * @param thsSourcesInitResults The sourcesInitResults to set.
     */
    public void setSourcesInitResults(Map thsSourcesInitResults) {
        this.sourcesInitResults = thsSourcesInitResults;
    }
    /**
     * @return Returns the initPerformMillis.
     */
    public long getInitPerformMillis() {
        return this.initPerformMillis;
    }
    /**
     * @param theInitPerformMillis The initPerformMillis to set.
     */
    public void setInitPerformMillis(long theInitPerformMillis) {
        this.initPerformMillis = theInitPerformMillis;
    }

}
