/*
 * Created on Feb 6, 2007
 * 
 * @author IE00165H - Alex Lara
 * (c) 2007 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

/**
 * Modela los datos devueltos por el buscador acerca
 * de un origen de resultados
 */
public class R01MSearchSourceResume implements Serializable {
    private static final long serialVersionUID = -1033316748314847436L;    
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Identificador del origen de resultados
     */
    @Getter @Setter private String sourceOid = null;
    /**
     * Nombre del origen de resultados
     */
    @Getter @Setter private String sourceName = null;
    /**
     * Destinos de publicacin permitidos para el origen
     * (se configura en el fichero r01kSearchEngineConfig.xml)
     */
    @Getter @Setter private List availablePublicationTargets = null;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio
     */
    public R01MSearchSourceResume() {
        super();
    }  
    /**
     * Constructor a partir de los datos del origen de resultados
     * @param newSourceOid identificacin del origen
     * @param newSourceName nombre del origen
     * @param newAvailablePublicationTargets lista de identificadores de los destinos de publicacin 
     *                                       permitidos para el origen
     */
    public R01MSearchSourceResume(final String newSourceOid,final String newSourceName,final List newAvailablePublicationTargets) {
        this.sourceOid = newSourceOid;
        this.sourceName = newSourceName;
        this.availablePublicationTargets = newAvailablePublicationTargets;
    } 
   
}
