/*
 * Created on Jul 21, 2005
 * 
 * @author IE00165H - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;


/**
 * Lnea (fila) de resultado de una bsqueda devuelta por un origen de resultados
 */
public class R01MSearchSourceResults implements Serializable {
    private static final long serialVersionUID = 4799008746406810070L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del origen de resultados
     */
    @Getter @Setter private String sourceOid = null;    
    /**
     * Datos sobre el origen de resultados
     */
    @Getter @Setter private R01MSearchSourceResume sourceDetails = null;
    /**
     * Numero de resultados del origen
     */
    @Getter @Setter private int numberOfResults = -1;    
    /**
     * Nmero de pginas de resultados
     */
    @Getter @Setter private int numberOfPages = -1;
    /**
     * Nmero de resultados por pgina
     */
    @Getter @Setter private int numberOfResultsPerPage;
    /**
     * Barra de navegacin por los resultados del origen
     */
    @Getter @Setter private R01MSearchNavBar navBar = null;
    /**
     * Resultados (objetos {@link R01MSearchResultItem})
     */
    @Getter @Setter private R01MSearchResultItem[] results = null;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vaco 
     */
    public R01MSearchSourceResults() {
        super();
    }
    /**
     * Obtiene los resultados de un origen
     * @param newSourceOid Identificador del origen de resultados
     */
    public R01MSearchSourceResults(String newSourceOid) {
        this.sourceOid = newSourceOid;
        this.sourceDetails = new R01MSearchSourceResume();
        this.sourceDetails.setSourceOid(newSourceOid);
    }
}
