/*
 * Created on Aug 19, 2005
 * 
 * @author IE00165H - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;

import com.ejie.r01f.util.Pager;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;

/**
 * <pre>
 * Resultado de la fase de inicializacin de la paginacin en UN ORIGEN de resultados
 * En la llamada a init() de cada uno de los orgenes de resultados se devuelve
 *      - Un objeto pager que controla la paginacin
 *      - El nmero de elementos para cada uno de los elementos por los que
 *        se puede filtrar en la guia de navegacin
 * Ejemplo:
 *      >> ElementoGuia1 (5)
 *      >> ElementoGuia2 (3)
 *      >> ElementoGuia3 (2)
 *      
 *           << 1 2 3 >>
 *      Resultado 1
 *      Resultado 2
 *      Resultado 3
 * </pre>
 */
public class R01MSearchSourceInitResult implements Serializable {
    private static final long serialVersionUID = -5023356748318845436L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del origen de resultados
     */
    public String sourceOid = null;    
    /**
     * Datos sobre el origen de resultados
     */
    public R01MSearchSourceResume sourceDetails = null;   
    /**
     * Paginador entre los resultados del origen
     */
    public Pager pager;
    /**
     * Elementos futuros en la gua de navegacin
     */
    public R01MSearchGuideElement[] guideFutureElements;
    /**
     * Resultados de la primera pgina
     * (solamente se inicializan si en la fase init se lanza con lazy=false)
     */
    public R01MSearchResultItem[] firstPageSearchResults;
    /**
     * Milisegundos que se ha tardado en hacer la inicializacin de este origen
     */
    public long initPerformMillis = Long.MIN_VALUE;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio
     */
    public R01MSearchSourceInitResult() {
        super();
    }
    /**
     * Constructor en base al paginador y al resumen de los eleemntos
     * futuros en la gua de navegacin
     * @param newSearchSrcOid Identificador del origen de resultados
     * @param newPager Paginador
     * @param newGuideFutureElements Elementos futuros en la guia de navegacin (si se utiliza)
     * @param newFirstPageSearchResults Los resultados de la primera pgina
     */
    public R01MSearchSourceInitResult(String newSearchSrcOid,
                                      Pager newPager,R01MSearchGuideElement[] newGuideFutureElements,
                                      R01MSearchResultItem[] newFirstPageSearchResults) {
        this();
        this.sourceOid = newSearchSrcOid;
        this.sourceDetails = new R01MSearchSourceResume();
        this.sourceDetails.setSourceOid(newSearchSrcOid);        
        this.pager = newPager;
        this.guideFutureElements = newGuideFutureElements;
        this.firstPageSearchResults = newFirstPageSearchResults;
    }    
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * @return Returns the guideFutureElements.
     */
    public R01MSearchGuideElement[] getGuideFutureElements() {
        return this.guideFutureElements;
    }
    /**
     * @param theGuideFutureElements The guideFutureElements to set.
     */
    public void setGuideFutureElements(R01MSearchGuideElement[] theGuideFutureElements) {
        this.guideFutureElements = theGuideFutureElements;
    }
    /**
     * @return Returns the pager.
     */
    public Pager getPager() {
        return this.pager;
    }
    /**
     * @param thePager The pager to set.
     */
    public void setPager(Pager thePager) {
        this.pager = thePager;
    }
    /**
     * @return Returns the sourceOid.
     */
    public String getSourceOid() {
        return this.sourceOid;
    }
    /**
     * @param theSourceOid The sourceOid to set.
     */
    public void setSourceOid(String theSourceOid) {
        this.sourceOid = theSourceOid;
    } 
    /**
     * @return Returns the sourceDetails
     */
    public R01MSearchSourceResume getSourceDetails() {
        return this.sourceDetails;
    }
    /**
     * @param theSourceDetails
     */
    public void setSourceDetails(R01MSearchSourceResume theSourceDetails) {
        this.sourceDetails = theSourceDetails;
    }
    /**
     * @return Returns the firstPageSearchResults.
     */
    public R01MSearchResultItem[] getFirstPageSearchResults() {
        return this.firstPageSearchResults;
    }
    /**
     * @param theFirstPageSearchResults The firstPageSearchResults to set.
     */
    public void setFirstPageSearchResults(R01MSearchResultItem[] theFirstPageSearchResults) {
        this.firstPageSearchResults = theFirstPageSearchResults;
    }    
    /**
     * @return Returns the initPerformMillis.
     */
    public long getInitPerformMillis() {
        return this.initPerformMillis;
    }
    /**
     * @param theInitPerformMillis The initPerformMillis to set.
     */
    public void setInitPerformMillis(long theInitPerformMillis) {
        this.initPerformMillis = theInitPerformMillis;
    }
}
