/*
 * Created on May 19, 2005
 * 
 * @author ie00165h
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;
/**
 * Informacin de la tipologa de un contenido
 *
 */
public class R01MSearchResultItemTypologyInfo implements Serializable {
    private static final long serialVersionUID = 6963192648613960753L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////    
     /**
      * Cluster al que pertenece el contenido
      */
     @Getter @Setter private String clusterOid;
     /**
      * Familia a la que se asocia el contenido
      */
     @Getter @Setter private String familyOid;     
     /**
      * Tipo de contenido
      */
     @Getter @Setter private String typeOid;
     /**
      * Identificador numerico del cluster : familia y tipo
      * Se obtiene como 1000000*clusterNumericId  + 100000*familyNumericId + 10000*typeNumericId 
      */
     @Getter @Setter private long numericId;
     /**
      * _Identificador numrico del cluster
      */
     @Getter @Setter private int clusterNumericId;
     /**
      * Identificador numrico de la familia
      */
     @Getter @Setter private int familyNumericId;
     /**
      * Identificador numrico del tipo
      */
     @Getter @Setter private int typeNumericId;
     /**
      * Trminos de bsqueda para el cluster 
      */
     @Getter @Setter private String clusterSearchTerms;
     /**
      * Trminos de bsqueda para la familia 
      */
     @Getter @Setter private String familySearchTerms;
     /**
      * Trminos de bsqueda para el tipo 
      */
     @Getter @Setter private String typeSearchTerms;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * 
     */
    public R01MSearchResultItemTypologyInfo() {
        super();
    }
    /**
     * Constructor
     * @param newClusterOid identificador del cluster
     * @param newFamilyOid identificador de la familia
     * @param newTypeOid identificador del tipo 
     * @param newClusterNumericId identificador numerico del cluster
     * @param newFamilyNumericId identificador numerico de la familia
     * @param newTypeNumericId identificador numerico del tipo
     */
    public R01MSearchResultItemTypologyInfo(String newClusterOid,String newFamilyOid,String newTypeOid,
                                            int newClusterNumericId,int newFamilyNumericId,int newTypeNumericId) {
        this();
        this.clusterOid = newClusterOid;
        this.familyOid = newFamilyOid;
        this.typeOid = newTypeOid;
        this.clusterNumericId = newClusterNumericId;
        this.familyNumericId = newFamilyNumericId;
        this.typeNumericId = newTypeNumericId;
    }   
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Devuelve si el objeto es valido
     * @return true si el objeto es valido
     */
    public boolean isValid() {
        return this.clusterOid != null && this.clusterOid.length() > 0 &&
               this.familyOid != null && this.familyOid.length() > 0 &&
               this.typeOid != null && this.typeOid.length() > 0;
    }
}
