/*
 * Created on Jul 21, 2005
 * 
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;


/**
 * <pre>
 * Catalogacin en una estructura (eje)
 * Toda catalogacin en un eje se compone de:
 *      - Eje en el que se ha realizado la catalogacin
 *      - Etiqueta de catalogacin
 *      - Rol que ocupa la etiqueta de catalogacin en el eje
 *          Una etiqueta en un eje SIEMPRE desempea un rol ya que la etiqueta
 *          puede pertenecer a ms de un eje, e incluso aparecer ms de una vez
 *          en el mismo eje.
 *          Para "distinguir" la etiqueta en el eje, se asocia un "rol" a la 
 *          etiqueta en el eje.
 *              Por ejemplo, la "viceconsejeria de turismo" ocupa el rol de 
 *              "viceconsejera" en el eje de estructura de gobierno
 * </pre>
 */
public class R01MSearchResultItemStructureCatalog implements Serializable {
    private static final long serialVersionUID = -2328615711258952555L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Identificador de la estructura en la que se ha catalogado
     */
    @Getter @Setter private String structureOid;
    /**
     * Identificador de la etiqueta que se ha asociado
     */
    @Getter @Setter private String labelOid;
    /**
     * Rol de la etiqueta en el eje
     */
    @Getter @Setter private String role;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Constructor vaco
     */
    public R01MSearchResultItemStructureCatalog() {
        super();      
    }
    /**
     * Constructor a partir de la estructura, la etiqueta y el rol de la etiqueta en la estructura
     * @param newStructureOid Identificador de la estructura
     * @param newLabelOid Identificador de la etiqueta
     * @param newRole Rol de la etiqueta en la estructura
     */
    public R01MSearchResultItemStructureCatalog(String newStructureOid,String newLabelOid,String newRole) {
        structureOid = newStructureOid;
        labelOid = newLabelOid;
        role = newRole;        
    }  
}
