/*
 * Created on Dec 7, 2006
 * 
 * @author IE00165H - Alex Lara
 * (c) 2006 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;
import java.util.Date;

import lombok.Getter;
import lombok.Setter;

/**
 * Informacin sobre la publicacin de un elemento de resultado
 * de bsqueda
 */
public class R01MSearchResultItemPublicationInfo implements Serializable{
    private static final long serialVersionUID = -6040205317948172556L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////    
    public static int ITEM_PUBLISHED = 1;
    public static int ITEM_UNPUBLISHED = 0;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Repositorio de publicacin
     */
    @Getter @Setter private String repositoryOid;
    /**
     * Alias del repositorio de publicacion
     */
    @Getter @Setter private String repositoryAlias;    
    /**
     * Fecha de publicacin
     */
    @Getter @Setter private Date date;
    /**
     * Estado de la publicacion 0: despublicado, 1: publicado
     */
    @Getter @Setter private int state;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio
     */
    public R01MSearchResultItemPublicationInfo() {
        
    }
    /**
     * Constructor a partir de los miembros
     * @param newRepositoryOid identificador del repositorio
     * @param newRepositoryAlias alias del repositorio
     * @param newState estado de publicacin 
     * @param newDate fecha de publicacin
     */
    public R01MSearchResultItemPublicationInfo(String newRepositoryOid,String newRepositoryAlias,int newState,Date newDate) {
        this.repositoryAlias = newRepositoryAlias;
        this.repositoryOid = newRepositoryOid;
        this.state = newState;
        this.date = newDate;        
    }
    /**
     * Constructor a partir de otro elemento
     * @param other el otro elemento
     */
    public R01MSearchResultItemPublicationInfo(R01MSearchResultItemPublicationInfo other) {
        this.repositoryAlias = other.repositoryAlias;
        this.repositoryOid = other.repositoryOid;
        this.state = other.state;
        this.date = other.date;
    }

}
