/*
 * Created on Dec 7, 2006
 * 
 * @author IE00165H - Alex Lara
 * (c) 2006 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;


/**
 * Localizacin en el gestor de contenidos de un resultado de bsqueda
 */
public class R01MSearchResultItemLocation implements Serializable {
    private static final long serialVersionUID = 6924252257347143224L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificacin del servidor
     */
    @Getter @Setter private String serverOid;
    /**
     * Identificacin del Repositorio
     */
    @Getter @Setter private String dataStoreOid;    
    /**
     * Identificacin del Area
     */
    @Getter @Setter private String areaOid;   
    /**
     * Identificacin del Area de Trabajo
     */
    @Getter @Setter private String workAreaOid;    
    /**
     * Path del servidor
     */
    @Getter @Setter private String serverPath = null;
    /**
     * Path del dataStore
     */
    @Getter @Setter private String dataStorePath = null;
    /**
     * Path del area
     */
    @Getter @Setter private String areaPath = null;
    /**
     * Path de la workArea
     */
    @Getter @Setter private String workAreaPath = null;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio
     */
    public R01MSearchResultItemLocation() {
    }
    /**
     * Constructor a partir de los miembros
     * @param newServerOid
     * @param newDataStoreOid
     * @param newAreaOid
     * @param newWorkAreaOid
     * @param newServerPath
     * @param newDataStorePath
     * @param newAreaPath
     * @param newWorkAreaPath
     */
    public R01MSearchResultItemLocation(String newServerOid,String newDataStoreOid,String newAreaOid,String newWorkAreaOid,
                                        String newServerPath,String newDataStorePath,String newAreaPath,String newWorkAreaPath) {
        serverOid = newServerOid;
        dataStoreOid = newDataStoreOid;
        areaOid = newAreaOid;
        workAreaOid = newWorkAreaOid;
        serverPath = newServerPath;
        dataStorePath = newDataStorePath;
        areaPath = newAreaPath;
        workAreaPath = newWorkAreaPath;
    }

}
