/*
 * Created on Aug 9, 2005
 *
 * @author IE00165H - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.Getter;
import lombok.Setter;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

/**
 * Elemento individual (lnea) de resultado de bsqueda.
 */
public class R01MSearchResultItem implements Serializable {
    /* (non-Javadoc)
     */
    private static final long serialVersionUID = -7276133116716145658L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS GENERALES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Nombre de la base de datos del buscador
     */
    @Getter @Setter private String searchEngineDBName = "default";
    /**
     * Nmero de item
     */
    @Getter @Setter private int itemNumber = -1;
    /**
     * Identificador del elemento en el resultset de resultados
     */
    @Getter @Setter private String itemId = "unknown";
    /**
     * Porcentage/ranking del resultado: fiabilidad de que el resultado
     * cumpla las expectativas de lo buscado
     */
    @Getter @Setter private float score = -1;
    /**
     * Identificador del origen de resultados que ha devuelto el item
     */
    @Getter @Setter private String searchSourceOid;
///////////////////////////////////////////////////////////////////////////////////////////
//  DATOS DEL CONTENIDO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Oid del contenido
     */
    @Getter @Setter private String contentOid;
    /**
     * Localizacin del contenido en el almacenamiento
     */
    @Getter @Setter private R01MSearchResultItemLocation contentLocation;
    /**
     * Tipologa del contenido
     */
    @Getter @Setter private R01MSearchResultItemTypologyInfo contentTypology;
    /**
     * Path relativo a la workArea del contenido
     */
    @Getter @Setter private String contentWorkAreaRelativePath;
    /**
     * Nombre del contenido
     */
    @Getter @Setter private String contentName;
    /**
     * Descripcion del contenido
     */
    @Getter @Setter private String contentDescription;
    /**
     * Autor del contenido
     */
    @Getter @Setter private String contentAuthor;
    /**
     * Responsable del contenido
     */
    @Getter @Setter private String contentResponsible;
    /**
     * Fecha de creacion del contenido
     */
    @Getter @Setter private Date contentCreateDate;
    /**
     * Fecha de vigencia del contenido como novedad
     */
    @Getter @Setter private Date contentNewnessUntilDate;
    /**
     * URLs de edicion en diferentes idiomas
     */
    @Getter @Setter private Map<String,String> contentEditURLs;
    /**
     * Informacin de la documentacin RISP (path,tamao)
     */
    @Getter @Setter private Map<String,String> contentRispDocumentsInfo;
///////////////////////////////////////////////////////////////////////////////////////////
//  CATALOGACIONES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Objetos R01MSearchResultItemStructureCatalog con las catalogaciones
     */
    @Getter @Setter private List<R01MSearchResultItemStructureCatalog> structureCatalogs;
    /**
     * Objetos R01MSearchResultItemGeoCatalog con las catalogaciones geogrficas
     */
    @Getter @Setter private List<R01MSearchResultItemGeoCatalog> geoCatalogs;
///////////////////////////////////////////////////////////////////////////////////////////
//  DATOS DEL DOCUMENTO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del documento.
     */
    @Getter @Setter private String documentOid;
    /**
     * Path relativo a la workArea del documento.
     */
    @Getter @Setter private String documentWorkAreaRelativePath;
    /**
     * Path relativo al contenido del documento.
     */
    @Getter @Setter private String documentContentRelativePath;
    /**
     * Nombre interno del documento.
     */
    @Getter @Setter private String documentInternalName;
    /**
     * Lenguaje del documento.
     */
    @Getter @Setter private String documentLanguage;
    /**
     * Nivel de profundidad del documento.
     */
    @Getter @Setter private String documentDepthLevel;
    /**
     * Fecha de creacin del documento.
     */
    @Getter @Setter private Date documentCreateDate;
    /**
     * Autor del documento.
     */
    @Getter @Setter private String documentAuthor;
    /**
     * Nombre del documento.
     */
    @Getter @Setter private String documentName;
    /**
     * Descripcin del documento.
     */
    @Getter @Setter private String documentDescription;
    /**
     * Estado del documento.
     */
    @Getter public String documentApprovalStatus;
    /**
     * Informacin de publicacin del documento.
     * (una lista de objetos {@link R01MSearchResultItemPublicationInfo})
     */
    @Getter @Setter private List<R01MSearchResultItemPublicationInfo> documentPublicationInfo;
    /**
     * Meta-Datos del documento (nombre en el lenguaje de la busqueda - valor).
     */
    @Getter @Setter private Map<String,?> documentMetaData;
    /**
     * @Setter privatee edicin en diferentes idiomas de usuario.
     */
    @Getter @Setter private Map<String,String> documentEditURLs;
    /**
     * Informacin de vinculaciones en las que el documento es el el origen de la relacion.
     * (una lista de objetos {@link R01MSearchResultItemDocumentLinkedDataInfo})
     */
    @Getter @Setter private List<R01MSearchResultItemDocumentLinkedDataInfo> linkedDocumentsByTagSrc;
    
    /**
     * Informacin devinculaciones en las que el documento es el el destino de la relacion.
     * (una lista de objetos {@link R01MSearchResultItemDocumentLinkedDataInfo})
     */
    @Getter @Setter private List<R01MSearchResultItemDocumentLinkedDataInfo> linkedDocumentsByTagDst;
    /**
     * URL amigable principal.
     */
    @Getter @Setter private String mainFriendlyURL;
    /**
     * Informacin del nmero de vinculaciones (tag, n de vinculaciones)
     */
    @Getter @Setter private Map linkedSizeByTagSrc;

///////////////////////////////////////////////////////////////////////////////////////////
//  DATOS DEL ARCHIVO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Nombre del fichero.
     */
    @Getter @Setter private String fileName;
    /**
     * Path relativo al documento del fichero encontrado.
     */
    @Getter @Setter private String fileURL;
    /**
     * Path relativo al documento del fichero.
     */
    @Getter @Setter private String fileDocumentRelativePath;
    /**
     * Path relativo a la workArea del fichero encontrado.
     */
    @Getter @Setter private String fileWorkAreaRelativePath;
    /**
     * Path del fichero que se ha indexado.
     */
    @Getter @Setter private String fileAbsolutePath;
    /**
     * Nombre del dataFile.
     */
    @Getter @Setter private String fileTitle;
    /**
     * Resumen del archivo (extracto del lugar donde se han encontrado las palabras).
     */
    @Getter @Setter private String fileResume;
    /**
     * <pre>
     * Indica si el fichero adjunto es el fichero de inicio del documento.
     * (se calcula en la clase {@link com.ejie.r01m.objects.searchengine.metadataprocessors.R01MMetaDataProcessorImpl}
     * que se encarga de obtener valores de metaDatos en funcion de otros valores).
     * </pre>
     */
    @Getter @Setter private boolean isDocumentMainDataFile;
    /**
     * <pre>
     * Path relativo a la workArea de la pgina de inicio del documento.
     * <b><red>OJO!!</red>:</b>
     * Corresponde a la generacin en HTML del dataFile de inicio
     * con la plantilla de presentacin POR DEFECTO (aquella marcada como main en el
     * ficehro templateManagementConfig.xml)
     * </pre>
     */
    @Getter @Setter private String documentMainDataFileDefaultGeneratedFileDocumentRelativePath;
    /**
     * <pre>
     * Path relativo al documento de los dataFiles de inicio generados
     * Es un mapa con los paths indexados por plantilla_presentacion/nombre_ficheroGenerado
     * <b><red>OJO!!</red>:</b>
     * Corresponde a la generacin en HTML del dataFile de inicio
     * con cada una de las plantillas de presentacin
     * </pre>
     */
    @Getter @Setter private Map<String,String> documentMainDataFileGeneratedFilesDocumentRelativePaths;
    /**
     * <pre>
     * Path relativo al documento de los datafiles generados.
     * Se trata de un Mapa con los paths indexados p
     * </pre>
     */
    @Getter @Setter private Map<String,String> documentDataFilesGeneratedFilesDocumentRelativePaths;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MSearchResultItem() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET / SET
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Devuelve un metaDato
     * @param metaDataOid identificador del metadato
     * @return valor del metadato
     */
    public String getDocumentMetaData(String metaDataOid) {
        // Tener cuidado con las fechas...
        if (this.documentMetaData != null && this.documentMetaData.get(metaDataOid) != null
         && this.documentMetaData.get(metaDataOid) instanceof java.util.Date) {
            // Devolver la fecha formateada
            return DateUtils.getDateLanguageFormated((Date)this.documentMetaData.get(metaDataOid),
                                                     null,      // R01MConstants.DEFAULT_LANG
                                                     R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);

        }
        // El resto de tipos devolverlo siempre como String
        return (this.documentMetaData != null && this.documentMetaData.get(metaDataOid) != null ? this.documentMetaData.get(metaDataOid).toString()
                                                                                                : null);
    }
}
