/*
 * Created on Aug 10, 2005
 * 
 * @author IE00165H - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;

/**
 * <pre>
 * Elemento de la barra de navegacin en un origen de bsqueda
 *      La barra de navegacin contiene las pginas de la bsqueda
 *      Ej: Una barra como << 1 2 3 >>
 *          Estara compuesta por 5 elementos:
 *              1.- << 
 *              2.- 1
 *              3.- 2
 *              4.- 3
 *              5.- >>
 * </pre>
 */
public class R01MSearchNavBarItem implements Serializable {
    private static final long serialVersionUID = 910019326125475597L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    // Identificadores del tipo de item
    /**
     * Primera pgina de la bsqueda.
     */
    public static final String ITEM_FIRST_PAGE = "firstPage";
    /**
     * Bloque anterior
     */
    public static final String ITEM_PREV_BLOCK = "previousBlock";
    /**
     * Pgina anterior a la actual en la bsqueda.
     */
    public static final String ITEM_PREV_PAGE = "prevPage";
    /**
     * Pgina X de la bsqueda.
     */
    public static final String ITEM_PAGE = "pageX";
    /**
     * Pgina posterior a la actual en la bsqueda.
     */
    public static final String ITEM_NEXT_PAGE = "nextPage";
    /**
     * Siguiente bloque
     */
    public static final String ITEM_NEXT_BLOCK = "nextBlock";
    /**
     * ltima pgina de la bsqueda.
     */
    public static final String ITEM_LAST_PAGE = "lastPage";
    
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Tipo de item de la barra de navegacion por las pginas.
     */
    public String itemType = ITEM_PAGE;
    /**
     * Numero de pgina al que corresponde el elemento.
     */
    public int pageNum = 1;     

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Constructor vacio.
     */
    public R01MSearchNavBarItem() {
        super();
    }
    /**
     * Constructor en base tipo de elemento y al nmero de pgina al que corresponde.
     * @param newNavBarItemType Tipo de elemento de la barra
     * @param newPageNum Numero de pgina al que corresponde el elemento
     */
    public R01MSearchNavBarItem(String newNavBarItemType,int newPageNum) {
        this.itemType = newNavBarItemType;
        this.pageNum = newPageNum;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the itemType.
     */
    public String getItemType() {
        return this.itemType;
    }
    /**
     * @param theItemType The itemText to set.
     */
    public void setItemType(String theItemType) {
        this.itemType = theItemType;
    }    
    /**
     * @return Returns the pageNum.
     */
    public int getPageNum() {
        return this.pageNum;
    }
    /**
     * @param thePageNum The pageNum to set.
     */
    public void setPageNum(int thePageNum) {
        this.pageNum = thePageNum;
    }

}
