/*
 * Created on Sep 2, 2005
 * 
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.results;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <pre>
 * Barra de Navegacin por los resultados de un origen
 * Una barra de navegacin tiene la pinta:
 *      |<< < 11 12 13 14 15 16 > >>|
 * por lo tanto hay varios elementos en la barra (elementos R01MSearchNavBarItem):
 *      - Elementos de control como |<<,< o >,>>|
 *      - Elementos de pgina coo 11,12,13,14,15,16
 * La barra de navegacin controla simplemente el nmero de orden del primer elemento (11),
 * del ltimo elemento (16) y del elemento actual (pe 15).
 * </pre>
 */
public class R01MSearchNavBar implements Serializable {
    private static final long serialVersionUID = -5246935201940661166L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MEMBERS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Tamao del bloque de la barra de navegacin
     */
    public int navBarBlockSize = 10;
    /**
     * Pgina actual
     */
    public int currentPage = -1;   
    /**
     * Nmero total de pginas
     */
    public int totalNumberOfPages = 0;
    /**
     * Nmero de orden del primer elemento de la pgina
     */
    public int currentPageFirstElementNumber = -1;
    /**
     * Nmero de orden del ltimo elemento de la pgina
     */
    public int currentPageLastElementNumber = -1;
    /**
     * Nmero total de resultados
     */
    public long totalNumberOfResults = -1;
    /**
     * Barra de navegacin: elementos de la barra de paginacin
     * (objetos tipo R01MSearchNavBarItem)
     */
    public List navBarItems = new ArrayList();    
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vaco
     */
    public R01MSearchNavBar() {
        super();
    }
    /**
     * Constructor complejo
     * @param newNavBarBlockSize tamao del bloque de la barra de navegacin
     * @param newCurrentPage Numero de la pgina actual 
     * @param newCurrentPageFirstElementNumber Nmero de orden del primer elemento de la pgina
     * @param newCurrentPageLastElementNumber Nmero de orden del ltimo elemento de la pgina
     */
    public R01MSearchNavBar(int newNavBarBlockSize,int newCurrentPage,int newCurrentPageFirstElementNumber,int newCurrentPageLastElementNumber) {
        this();
        this.navBarBlockSize = newNavBarBlockSize;
        this.currentPage = newCurrentPage;
        this.currentPageFirstElementNumber = newCurrentPageFirstElementNumber;
        this.currentPageLastElementNumber = newCurrentPageLastElementNumber;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS PUBLICOS 
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Aade un elemento a la barra de navegacin
     * @param itemType Tipo de elemento
     * @param pageNum Numero de pgina
     */
    public void addItem(String itemType,int pageNum) {
        if(this.navBarItems == null) this.navBarItems = new ArrayList();
        this.navBarItems.add( new R01MSearchNavBarItem(itemType,pageNum) );
    } 
    /**
     * Encuentra el primer elemento tipo page
     * @return el primer elemento tipo page
     */
    public R01MSearchNavBarItem findFirstPageItem() {
        if (this.navBarItems == null) return null;
        R01MSearchNavBarItem outItem = null;
        R01MSearchNavBarItem currItem = null;
        for (int i=0; i<this.navBarItems.size(); i++) {
            currItem = (R01MSearchNavBarItem)this.navBarItems.get(i);
            if (currItem.getItemType().equals(R01MSearchNavBarItem.ITEM_PAGE)) {
                outItem = currItem;
                break;
            }
        }
        return outItem;
    }
    /**
     * Encuentra el ultimo elemento tipo page
     * @return el ultimo elemento tipo page
     */
    public R01MSearchNavBarItem findLastPageItem() {
        if (this.navBarItems == null) return null;
        R01MSearchNavBarItem outItem = null;
        R01MSearchNavBarItem currItem = null;
        for (int i=this.navBarItems.size()-1; i>=0; i--) {
            currItem = (R01MSearchNavBarItem)this.navBarItems.get(i);
            if (currItem.getItemType().equals(R01MSearchNavBarItem.ITEM_PAGE)) {
                outItem = currItem;
                break;
            }
        }
        return outItem;
    }    
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return navBarBlockSize
     */
    public int getNavBarBlockSize() {
        return this.navBarBlockSize;
    }
    /**
     * @param theNavBarBlockSize
     */
    public void setNavBarBlockSize(int theNavBarBlockSize) {
        this.navBarBlockSize = theNavBarBlockSize;
    }  
    /**
     * @return totalNumberOfResults
     */
    public long getTotalNumberOfResults() {
        return this.totalNumberOfResults;
    }
    /**
     * @param theTotalNumberOfResults
     */
    public void setTotalNumberOfResults(long theTotalNumberOfResults) {
        this.totalNumberOfResults = theTotalNumberOfResults;
    }     
    /**
     * @return Returns the currentPage.
     */
    public int getCurrentPage() {
        return this.currentPage;
    }
    /**
     * @param theCurrentPage The currentPage to set.
     */
    public void setCurrentPage(int theCurrentPage) {
        this.currentPage = theCurrentPage;
    }
    /**
     * @return Returns the navBarItems.
     */
    public List getNavBarItems() {
        return this.navBarItems;
    }
    /**
     * @param theNavBar The navBarItems to set.
     */
    public void setNavBarItems(List theNavBar) {
        this.navBarItems = theNavBar;
    }
    /**
     * Devuelve el nmero total de pginas
     * @return el nmero total de pginas
     */
    public int getTotalNumberOfPages() {
        return this.totalNumberOfPages;
    }
    /**
     * @param theTotalPages
     */
    public void setTotalNumberOfPages(int theTotalPages) {
        this.totalNumberOfPages = theTotalPages;
    } 
    /**
     * @return Returns the currentPageFirstElementNumber.
     */
    public int getCurrentPageFirstElementNumber() {
        return this.currentPageFirstElementNumber;
    }
    /**
     * @param theCurrentPageFirstElementNumber The currentPageFirstElementNumber to set.
     */
    public void setCurrentPageFirstElementNumber(int theCurrentPageFirstElementNumber) {
        this.currentPageFirstElementNumber = theCurrentPageFirstElementNumber;
    }
    /**
     * @return Returns the currentPageLastElementNumber.
     */
    public int getCurrentPageLastElementNumber() {
        return this.currentPageLastElementNumber;
    }
    /**
     * @param theCurrentPageLastElementNumber The currentPageLastElementNumber to set.
     */
    public void setCurrentPageLastElementNumber(int theCurrentPageLastElementNumber) {
        this.currentPageLastElementNumber = theCurrentPageLastElementNumber;
    } 

}
