package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;


/**
 * Workarea que se incluye en una query como condicin de
 * bsqueda
 */
public class R01MSearchedWorkArea extends R01MBaseSearchedStorageObj implements Serializable {
    private static final long serialVersionUID = 1119770168557331887L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del servidor
     */
    public String serverOid;
    /**
     * Identificador del repositorio de datos
     */
    public String dataRepositoryOid;
    /**
     * Identificador del area
     */
    public String areaOid;
    /**
     * Identificador del workArea
     */
    public String workAreaOid;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
	public R01MSearchedWorkArea() {
        super();
	} 
    /**
     * Constructor a partir de los oids
     * @param newServerOid Identificador del servidor
     * @param newDataStoreOid Identificador del dataStore
     * @param newAreaOid Identificador del Area
     * @param newWorkAreaOid Identificador del WorkArea
     */
    public R01MSearchedWorkArea(String newServerOid,String newDataStoreOid,String newAreaOid,String newWorkAreaOid) {
        this();
        this.serverOid = newServerOid;
        this.dataRepositoryOid = newDataStoreOid;
        this.areaOid = newAreaOid;
        this.workAreaOid = newWorkAreaOid;
    }
    /**
     * Constructor a partir del identificador y el nombre
     * @param newServerOid Identificador del servidor al que pertenece el area
     * @param newDataRepositoryOid Identificador del repositorio de datos al que pertenece el area
     * @param newAreaOid Identificador del area al que pertenece la workArea 
     * @param newWorkAreaOid Identificador
     * @param newName Nombre
     */
    public R01MSearchedWorkArea(String newServerOid,String newDataRepositoryOid,String newAreaOid,String newWorkAreaOid,String newName) {
        this(newServerOid,newDataRepositoryOid,newAreaOid,newWorkAreaOid);                
        this.name = newName;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedWorkArea) {
            R01MSearchedWorkArea otherWA = (R01MSearchedWorkArea)other;
            boolean eq = true;
            eq &= (this.serverOid != null && otherWA.serverOid != null && this.serverOid.equals(otherWA.serverOid));
            eq &= (this.dataRepositoryOid != null && otherWA.dataRepositoryOid != null && this.dataRepositoryOid.equals(otherWA.dataRepositoryOid));
            eq &= (this.areaOid != null && otherWA.areaOid != null && this.areaOid.equals(otherWA.areaOid));
            eq &= (this.workAreaOid != null && otherWA.workAreaOid != null && this.workAreaOid.equals(otherWA.workAreaOid));            
            return eq;
        }
        return false;
    }    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeDebugInfo()
     */
    public String composeDebugInfo() {
        return "serverOid=" + this.serverOid + " dataStoreOid=" + this.dataRepositoryOid + " area=" + this.areaOid + " workArea=" + this.workAreaOid;
    }    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeQueryString()
     */
    public String getKey() {
        return this.getServerOid() + "." + this.getDataRepositoryOid() + "." + this.getAreaOid() + "." + this.getWorkAreaOid();
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key del objeto de almacenamiento workArea NO es valida: ha de tener el formato serverOid.dataRepositoryOid.areaOid.workAreaOid");
            return;
        }
        // La clave de una workArea es serverOid.dataRepositoryOid.areaOid.workAreaOid
        String[] keySplitted = key.split("\\.");
        if (keySplitted.length != 4) {
            R01FLog.to("r01m.searchEngine").severe("La key del workArea " + key + " NO es valida: ha de tener el formato serverOid.dataRepositoryOid.areaOid.workAreaOid");
        } else {
            this.serverOid = keySplitted[0];
            this.dataRepositoryOid = keySplitted[1];
            this.areaOid = keySplitted[2];
            this.workAreaOid = keySplitted[3];
        }
    }    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj#getStorageObjOid()
     */
    public String getStorageObjOid() {
        return this.getWorkAreaOid();
    }    
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the serverOid.
     */
    public String getServerOid() {
        return this.serverOid;
    }
    /**
     * @param theServerOid The serverOid to set.
     */
    public void setServerOid(String theServerOid) {
        this.serverOid = theServerOid;
    }
    /**
     * @return Returns the dataRepositoryOid.
     */
    public String getDataRepositoryOid() {
        return this.dataRepositoryOid;
    }
    /**
     * @param theDataRepositoryOid The dataRepositoryOid to set.
     */
    public void setDataRepositoryOid(String theDataRepositoryOid) {
        this.dataRepositoryOid = theDataRepositoryOid;
    }
    /**
     * @return Returns the areaOid.
     */
    public String getAreaOid() {
        return this.areaOid;
    }
    /**
     * @param theAreaOid The areaOid to set.
     */
    public void setAreaOid(String theAreaOid) {
        this.areaOid = theAreaOid;
    }
    /**
     * @return Returns the workAreaOid.
     */
    public String getWorkAreaOid() {
        return this.workAreaOid;
    }
    /**
     * @param theWorkAreaOid The workAreaOid to set.
     */
    public void setWorkAreaOid(String theWorkAreaOid) {
        this.workAreaOid = theWorkAreaOid;
    }    
}
