/*
 * Created on 27-may-2005
 *
 * @author co01556e
 */
package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;

/**
 * Modela una etiqueta de catalogacin en la que debe estar
 * catalogado algn recurso y por la cual se busca
 */
public class R01MSearchedStructureCatalog extends R01MBaseSearchedObj implements Serializable {
    private static final long serialVersionUID = 3028783293382955750L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MEMBERS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador de la estructura (eje)
     */
    public String structureOid;
    /**
     * Identificador de la etiqueta (etiquetaOID)
     */
	public String labelOid ;
    /**
     * Identificador numrico (utilizado en bsquedas para acelerar)
     */
    private int labelNumericId = -1;
	/**
	 * Nivel de la etiqueta dentro de la estructura
	 */
	public String role;
	/**
	 * Indica si debe utilizarse la estructura y el role en las bsquedas.
	 */
	public boolean useStructureAndRole = false;

	
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
	public R01MSearchedStructureCatalog() {
		this.labelOid = "";
		this.structureOid="";
		this.role = "";
	}
    /**
     * Constructor en base al identificador de la etiqueta
     * @param newLabelOid Identificador de la etiqueta
     */
    public R01MSearchedStructureCatalog(String newLabelOid) {
        this.labelOid = newLabelOid;
    }
	/**
     * Constructor en bae al identificador de la etiqueta
     * @param newLabelOid Identificador de la etiqueta
     * @param newStructureOid identificador de la estructura
     * @param newRole identificador del rol en la estructura
	 */
	public R01MSearchedStructureCatalog(String newLabelOid, String newStructureOid, String newRole) {
		this.labelOid = newLabelOid;
		this.structureOid = newStructureOid;
		this.role = newRole;
	}
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedStructureCatalog) {
            R01MSearchedStructureCatalog otherCat = (R01MSearchedStructureCatalog)other;
            boolean eq = true;
            eq &= (this.labelOid != null && otherCat.labelOid != null && this.labelOid.equals(otherCat.labelOid));
            return eq;
        }
        return false;
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeDebugInfo()
     */
    public String composeDebugInfo() {
        return "labelId=" + this.labelOid + " structureId= " + this.structureOid + " role=" + this.role;
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeQueryString()
     */
    public String getKey() {
        return this.labelOid;
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key de la catalogacion NO es valida: ha de tener el formato labelOid");
            return;
        }
        // La clave de una catalogacin es directamente el identificador de la etiqueta
        this.labelOid = key;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the structureOid.
     */
    public String getStructureOid() {
        return this.structureOid;
    }
    /**
     * @param theStructureOid The structureOid to set.
     */
    public void setStructureOid(String theStructureOid) {
        this.structureOid = theStructureOid;
    }
    /**
     * @return the labelOid
     */
    public String getLabelOid() {
        return this.labelOid;
    }
    /**
     * @param theLabelOid the labelOid to set
     */
    public void setLabelOid(String theLabelOid) {
        this.labelOid = theLabelOid;
    }
	/**
	 * @return Returns the role.
	 */
	public String getRole() {
		return this.role;
	}
	/**
	 * @param theRole The role to set.
	 */
	public void setRole(String theRole) {
		this.role = theRole;
	}
    /**
     * @return Returns the labelNumericId
     */
    public int getLabelNumericId() {
        return this.labelNumericId;
    }
    /**
     * @param theLabelNumericId
     */
    public void setLabelNumericId(int theLabelNumericId) {
        this.labelNumericId = theLabelNumericId;
    }
    /**
     * @return the useStructureAndRole
     */
    public boolean isUseStructureAndRole() {
        return this.useStructureAndRole;
    }
    /**
     * @param theUseStructureAndRole The useStructureAndRole to set.
     */
    public void setUseStructureAndRole(boolean theUseStructureAndRole) {
        this.useStructureAndRole = theUseStructureAndRole;
    }
}
