package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;


/**
 * Servidor que se incluye en una query como condicin de
 * bsqueda
 */
public class R01MSearchedServer extends R01MBaseSearchedStorageObj implements Serializable {
    private static final long serialVersionUID = 8420230425464340622L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del servidor
     */
    public String serverOid;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MSearchedServer() {
        super();
    }
    /**
     * Constructor a partir del OID del servidor
     * @param newServerOid
     */
    public R01MSearchedServer(String newServerOid) {
        this();
        this.serverOid = newServerOid;
    }
    /**
     * Constructor a partir del identificador y el nombre
     * @param newServerOid Identificador
     * @param newName Nombre
     */
    public R01MSearchedServer(String newServerOid,String newName) {
        this(newServerOid);
        this.name = newName;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedServer) {
            R01MSearchedServer otherSrvr = (R01MSearchedServer)other;
            boolean eq = true;
            eq &= (this.serverOid != null && otherSrvr.serverOid != null && this.serverOid.equals(otherSrvr.serverOid));            
            return eq;
        }
        return false;
    }    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeDebugInfo()
     */
    public String composeDebugInfo() {
        return "serverOid=" + this.getServerOid();
    }   
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeQueryString()
     */
    public String getKey() {
        return this.getServerOid();
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key del objeto de almacenamiento server NO es valida: ha de tener el formato serverOid");
            return;
        }
        // La clave de un server es serverOid
        this.serverOid = key;
    }    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj#getStorageObjOid()
     */
    public String getStorageObjOid() {
        return this.getServerOid();
    }    
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * @return Returns the serverOid.
     */
    public String getServerOid() {
        return this.serverOid;
    }
    /**
     * @param theServerOid The serverOid to set.
     */
    public void setServerOid(String theServerOid) {
        this.serverOid = theServerOid;
    }    
}
