package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;

/**
 * Criterio de bsqueda sobre un repositorio de publicacin
 */
public class R01MSearchedPublishRepository extends R01MBaseSearchedObj implements Serializable {
    private static final long serialVersionUID = -890824765475844486L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del repositorio
     */
    public String oid;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Constructor vacio
     */
    public R01MSearchedPublishRepository() {
		super();
	}
    /**
     * Constructor en base a un oid de repositorio
     * @param newOid
     */
	public R01MSearchedPublishRepository(String newOid){
		this();
		this.oid = newOid;
	}
    /**
     * Constructor a partir del oid, el nombre interno y el nombre 
     * @param newOid Identificador del repositorio
     * @param newName Nombre del repositorio
     */
    public R01MSearchedPublishRepository(String newOid,String newName) {
        this(newOid);
        this.name = newName;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedPublishRepository) {
            R01MSearchedPublishRepository otherPR = (R01MSearchedPublishRepository)other;
            boolean eq = true;
            eq &= (this.oid != null && otherPR.oid != null && this.oid.equals(otherPR.oid));                     
            return eq;
        }
        return false;
    }    
    /**
     * Compone informacion de depuracion
     * @return una cadena con informacion de depuracion
     */
    public String composeDebugInfo() {
        return "oid=" + this.getOid() + " name=" + this.getName(); 
    }  
    /**
     * Compone un identificador del objeto que se puede incluir en una url
     * y que permitir identificarlo
     * @return una cadena incluible en una url
     */
    public String getKey() {
        return this.getOid();
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key del repositorio de publicacion NO es valida: ha de tener el formato publishRepositoryOid");
            return;
        }
        // La clave de un repositorio de publicacion es directamente el oid
        this.oid = key;
    }     
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * @return Returns the oid.
     */
    public String getOid() {
        return this.oid;
    }
    /**
     * @param theOid The oid to set.
     */
    public void setOid(String theOid) {
        this.oid = theOid;
    }
	
}
