/*
 * Created on 27-may-2005
 * @author co01556e
 */
package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;



/**
 * Modela las condiciones que se imponen sobre un metadato que forma parte de una query 
 * al buscador
 */
public class R01MSearchedOrderByMetaData extends R01MBaseSearchedTypoObj implements Serializable {
    private static final long serialVersionUID = 1594950051322696084L;

///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Ordenacion
     */
    public String order;
    
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MSearchedOrderByMetaData() {
        super();
    }  
    /**
     * Constructor a partir del oid del metaDato de ordenacin
     * @param newOid Identificador del metaDato
     * @param newOrder orden
     */
    public R01MSearchedOrderByMetaData(String newOid,String newOrder) {
        this();
        this.oid = newOid;
        this.order = newOrder;
    }
    /**
     * Constructor a partir del identificador, nombre, operacin y valor
     * @param newOid Identificador
     * @param newName Nombre
     * @param newOrder Ordenacion
     */
    public R01MSearchedOrderByMetaData(String newOid,String newName,String newOrder) {
        this(newOid,newName);
        this.order = newOrder;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedOrderByMetaData) {
            R01MSearchedOrderByMetaData otherMD = (R01MSearchedOrderByMetaData)other;
            boolean eq = true;
            eq &= (this.oid != null && otherMD.oid != null && this.oid.equals(otherMD.oid));                     
            return eq;
        }
        return false;
    }     
    /**
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedTypoObj#composeDebugInfo()
     */
    public String composeDebugInfo() {
        return super.composeDebugInfo() + " order=" + this.order;
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeQueryString()
     */
    public String getKey() {
        return (this.getOid() + "." + this.getOrder()); 
    } 
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key del metaDato de ordenacion NO es valida: ha de tener el formato metaDataOid.order");
            return;
        }
        // La clave de un metaDato de ordenacion es metaDataOid.order
        String[] keySplitted = key.split("\\.");
        if (keySplitted.length != 2) {
            R01FLog.to("r01m.searchEngine").severe("La key del metaDato de ordenacion " + key + " NO es valida: ha de tener el formato metaDataOid.order");
        } else {
            this.oid = keySplitted[0];
            this.order = keySplitted[1];
        }
    }     
///////////////////////////////////////////////////////////////////////////////////////////
//  GETTERS & SETTERS
///////////////////////////////////////////////////////////////////////////////////////////  
    /**
     * @return Returns the operationSelected.
     */
    public String getOrder() {
        return this.order;
    }
    /**
     * @param theOrder The order to set.
     */
    public void setOrder(String theOrder) {
        this.order = theOrder;
    }   	
}
