/*
 * Created on 27-may-2005
 * @author co01556e
 */
package com.ejie.r01m.objects.searchengine.query;

import com.ejie.r01f.log.R01FLog;

/**
 * Modela las condiciones que se imponen sobre un metadato que forma parte de una query 
 * al buscador.
 */
public class R01MSearchedMetaData extends R01MBaseSearchedTypoObj {
    private static final long serialVersionUID = 1594950051322696084L;

///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////            
    /**
     * Operacin seleccionada.
     */
    public String operationSelected;    
    /**
     * Texto introducido por el usuario.
     */
    public String value;
    /**
     * Grupo al que pertenece para la ordenacin de datos en la presentacin.
     */
    public String presentationGroup;
    
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MSearchedMetaData() {
        super();
    }    
    /**
     * Constructor a partir del identificador del metadato
     * @param newOid Identificador
     */
    public R01MSearchedMetaData(String newOid) {
        this();
        this.oid = newOid;
    }
    /**
     * Constructor a partir del identificador del metadato
     * @param newOid Identificador
     * @param newOperationSelected operacion sobre el metadato
     * @param newValue Nuevo valor del metaDato
     */
    public R01MSearchedMetaData(String newOid,String newOperationSelected,String newValue) {
        this(newOid);
        this.value = newValue;
        this.operationSelected = newOperationSelected;
    }          
    /**
     * Constructor a partir del identificador, nombre, operacin y valor
     * @param newOid Identificador
     * @param newName Nombre
     * @param newOperationSelected Operacion seleccionada
     * @param newValue Valor
     */
    public R01MSearchedMetaData(String newOid,String newName,String newOperationSelected,String newValue) {
        this(newOid,newOperationSelected,newValue);
        this.name = newName;
    }  
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedMetaData) {
            R01MSearchedMetaData otherMD = (R01MSearchedMetaData)other;
            boolean eq = true;
            eq &= (this.oid != null && otherMD.oid != null && this.oid.equals(otherMD.oid));            
            eq &= (this.operationSelected != null && otherMD.operationSelected != null && this.operationSelected.equals(otherMD.operationSelected));
            eq &= (this.value != null && otherMD.value != null && this.value.equals(otherMD.value));            
            return eq;
        }
        return false;
    }    
    /**
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedTypoObj#composeDebugInfo()
     */
    public String composeDebugInfo() {
        return super.composeDebugInfo() + " value=" + this.value + " operationSelected=" + this.operationSelected;
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeQueryString()
     */
    public String getKey() {
        return (this.getOid() + "." + this.getOperationSelected() + "." + this.getValue()); 
    }  
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key del metaDato NO es valida: ha de tener el formato metaDataOid.operationSelected.value");
            return;
        }
        // La clave de un metaDato es metaDataOid.operationSelected.value
        String[] keySplitted = key.split("\\.");
        //Se contempla el caso de que en el fullText venga texto con punto. Ej: euskadi.net 
        if (keySplitted.length != 3 && !keySplitted[0].contentEquals(new StringBuffer("fullText"))) {
            R01FLog.to("r01m.searchEngine").severe("La key del metaDato " + key + " NO es valida: ha de tener el formato metaDataOid.operationSelected.value");
        } else {
            this.oid = keySplitted[0];
            this.operationSelected = keySplitted[1];
            this.value="";
            for (int i=2; i < keySplitted.length; i++) {
                this.value = this.value + (i==2 ? "" : ".") + keySplitted[i];    
            }
        }
    }    
///////////////////////////////////////////////////////////////////////////////////////////
//  GETTERS & SETTERS
///////////////////////////////////////////////////////////////////////////////////////////  
    /**
     * @return Returns the operationSelected.
     */
    public String getOperationSelected() {
        return this.operationSelected;
    }
    /**
     * @param theOperationSeleted The operationSelected to set.
     */
    public void setOperationSelected(String theOperationSeleted) {
        this.operationSelected = theOperationSeleted;
    }   	
	/**
	 * @return Returns the value.
	 */
	public String getValue() {
		return this.value;
	}
	/**
	 * @param theValue The textFields to set.
	 */
	public void setValue(String theValue) {
		this.value = theValue;
	}
	/**
	 * @return Returns the presentationGroup.
	 */
	public String getPresentationGroup() {
		return this.presentationGroup;
	}
	/**
	 * @param thePresentationGroup The presentationGroup to set.
	 */
	public void setPresentationGroup(String thePresentationGroup) {
		this.presentationGroup = thePresentationGroup;
	}
	
}
