/*
 * Created on Jul 1, 2007
 * 
 * @author IE00165H - Alex Lara
 * (c) 2007 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

/**
 * Si una condicin de la query procede de una condicin impuesta al navegar
 * por una gua de navegacin, en este punto se detalla la gua y el elemento
 * de la gua.
 */
public class R01MSearchedGuideConditionDetails implements Serializable {
    private static final long serialVersionUID = 7953777092602053663L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador de la gua de navegacin
     */
    public String guideOid;                 // Identificador de la gua
    /**
     * Path del branch en la gua
     */
    public String branchDefPath;            // Path del branch en la gua
    /**
     * Path del elemento en la gua
     */
    public String elementPathInBranch;      // Path del elemento dentro del branch
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor
     */
    public R01MSearchedGuideConditionDetails() {       
    }
    /**
     * Constructor en base a los elementos del objeto
     * @param newGuideOid identificador de la gua de navegacin
     * @param newBranchDefPath path del branch dentro de la gua
     * @param newElementPathInBranch path del elemento dentro del branch
     */
    public R01MSearchedGuideConditionDetails(String newGuideOid,String newBranchDefPath,String newElementPathInBranch) {
        this.guideOid = newGuideOid;
        this.branchDefPath = newBranchDefPath;
        this.elementPathInBranch = newElementPathInBranch;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the guideOid
     */
    public String getGuideOid() {
        return this.guideOid;
    }
    /**
     * @param theGuideOid
     */
    public void setGuideOid(String theGuideOid) {
        this.guideOid = theGuideOid;
    }    
    /**
     * @return Returns the branchDefPath
     */
    public String getBranchDefPath() {
        return this.branchDefPath;
    }
    /**
     * @param theBranchDefPath
     */
    public void setBranchDefPath(String theBranchDefPath) {
        this.branchDefPath = theBranchDefPath;
    }
    /**
     * @return Returns the elementPathInBranch
     */
    public String getElementPathInBranch() {
        return this.elementPathInBranch;
    }
    /**
     * @param theElementPathInBranch
     */
    public void setElementPathInBranch(String theElementPathInBranch) {
        this.elementPathInBranch = theElementPathInBranch;
    }
    
    
}
