package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;
/**
* Modela una etiqueta de catalogacin geogrfica en la que debe estar catalogado algn recurso y por la cual se busca.
*/
public class R01MSearchedGeoCatalog extends R01MBaseSearchedObj implements Serializable{
    private static final long serialVersionUID = -5948116112295414471L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MEMBERS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador de la provincia
     */
    public String provinceId;
    /**
     * Identificador del miunicipio
     */
    public String municipalId;    
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio
     */
    public R01MSearchedGeoCatalog() {
		super();
	}    
    /**
     * Constructor en base a la provincia y municipio
     * @param newProvinceId
     * @param newMunicipalityId
     */
    public R01MSearchedGeoCatalog(String newProvinceId, String newMunicipalityId) {
		this.provinceId = newProvinceId;
		this.municipalId = newMunicipalityId;
	}
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedGeoCatalog) {
            R01MSearchedGeoCatalog otherCat = (R01MSearchedGeoCatalog)other;
            boolean eq = true;
            eq &= (this.provinceId != null && otherCat.provinceId != null && this.provinceId.equals(otherCat.provinceId));
            eq &= (this.municipalId != null && otherCat.municipalId != null && this.municipalId.equals(otherCat.municipalId));             
            return eq;
        }
        return false;
    }    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeDebugInfo()
     */
    public String composeDebugInfo() {
        return "provinceOid=" + this.getProvinceId() + " municipalityOid=" + this.getMunicipalId();
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeQueryString()
     */
    public String getKey() {
        return (this.getProvinceId() + "." + this.getMunicipalId()); 
    } 
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key de la catalogacin geogrfica NO es valida: ha de tener el formato provinceOid.municipalityOid");
            return;
        }
        // La clave de un metaDato es metaDataOid.operationSelected.value
        String[] keySplitted = key.split("\\.");
        if (keySplitted.length != 2) {
            R01FLog.to("r01m.searchEngine").severe("La key de la catalogacin geogrfica " + key + " NO es valida: ha de tener el formato provinceOid.municipalityOid");
        } else {
            this.provinceId = keySplitted[0];
            this.municipalId = keySplitted[1];
        }
    }     
///////////////////////////////////////////////////////////////////////////////////////////
//  SET / GET
///////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @return Returns the municipalId.
	 */
	public String getMunicipalId() {
		return this.municipalId;
	}
	/**
	 * @param theMunicipalId The municipalId to set.
	 */
	public void setMunicipalId(String theMunicipalId) {
		this.municipalId = theMunicipalId;
	}
	/**
	 * @return Returns the provinceId.
	 */
	public String getProvinceId() {
		return this.provinceId;
	}
	/**
	 * @param theProvinceId The provinceId to set.
	 */
	public void setProvinceId(String theProvinceId) {
		this.provinceId = theProvinceId;
	}
	
}
